<?php 
	/*	
	*	Goodlayers Core Plugin Filter
	*	---------------------------------------------------------------------
	*	This file contains the script to includes necessary function
	* 	for compatibility with goodlayers core plugin
	*	---------------------------------------------------------------------
	*/

	add_filter('gdlr_core_use_font_icons', 'financity_gdlr_core_use_font_icons');
	if( !function_exists('financity_gdlr_core_use_font_icons') ){
		function financity_gdlr_core_use_font_icons( $icons ){
			return financity_get_option('plugin', 'font-icon', $icons);
		}
	} 
	
	// add body class for page builder
	add_filter('gdlr_core_page_builder_body_class', 'financity_page_builder_body_class');
	if( !function_exists('financity_page_builder_body_class') ){
		function financity_page_builder_body_class( $classes ) {
			return $classes . ' financity-body';
		}
	}
	add_filter('gdlr_core_sidebar_class', 'financity_gdlr_core_sidebar_class');
	if( !function_exists('financity_gdlr_core_sidebar_class') ){
		function financity_gdlr_core_sidebar_class( $classes ) {
			return $classes . ' financity-sidebar-area';
		}
	}

	// Set the neccessary function to be used in the theme
	add_action('after_setup_theme', 'financity_goodlayers_core_setup');
	if( !function_exists( 'financity_goodlayers_core_setup' ) ){
		function financity_goodlayers_core_setup(){

			// to set the goodlayers core plugin pagination
			add_filter('gdlr_core_pagination_style', 'financity_gdlr_core_pagination_style');
			add_filter('gdlr_core_pagination_align', 'financity_gdlr_core_pagination_align');

			// set the default social share option
			add_filter('gdlr_core_social_share_list', 'financity_gdlr_core_social_share_list');

			// widget title navigation
			add_filter('gdlr_core_widget_title_nav', 'financity_gdlr_core_widget_title_nav');

			// single portfolio
			add_filter('gdlr_core_custom_post_slug', 'financity_gdlr_core_custom_post_slug', 10, 2);

			add_filter('gdlr_core_portfolio_single_nav', 'financity_gdlr_core_portfolio_single_nav');
			add_filter('gdlr_core_portfolio_single_nav_same_term', 'financity_gdlr_core_portfolio_single_nav_same_term');
			add_filter('gdlr_core_portfolio_single_related', 'financity_gdlr_core_portfolio_single_related');

			// srcset
			add_filter('gdlr_core_enable_srcset', 'financity_gdlr_core_enable_srcset');

			// filter for portfolio icon hover
			add_filter('gdlr_core_portfolio_hover_icon_class', 'financity_gdlr_core_portfolio_hover_icon_class');
			
			// youtube cookies
			add_filter('gdlr_core_privacy_settings', 'financity_gdlr_core_privacy_settings');
		}
	}

	// youtube no cookies
	if( !function_exists('financity_gdlr_core_privacy_settings') ){
		function financity_gdlr_core_privacy_settings(){
			if( function_exists('gdlr_core_get_privacy_options') ){
				$privacy_options = gdlr_core_get_privacy_options(1) + gdlr_core_get_privacy_options(2);
				$privacy_settings = array();
				foreach( $privacy_options as $privacy_option_slug => $privacy_option ){
					$privacy_settings[$privacy_option_slug] = financity_get_option('plugin', $privacy_option_slug, 
						(empty($privacy_option['default'])? '': $privacy_option['default']));
				}

				return $privacy_settings;
			}
			
			return array();
		}
	}


	// portfolio hover icon class
	if( !function_exists('financity_gdlr_core_portfolio_hover_icon_class') ){
		function financity_gdlr_core_portfolio_hover_icon_class( $type = '' ){
			if( $type == 'image' ){
			 	return financity_get_option('general', 'portfolio-icon-hover-image', '');
			}else if( $type == 'video' ){
				return financity_get_option('general', 'portfolio-icon-hover-video', '');
			}else if( $type == 'link' ){
				return financity_get_option('general', 'portfolio-icon-hover-link', '');
			}
		}
	}

	// to enable srcset
	if( !function_exists('financity_gdlr_core_enable_srcset') ){
		function financity_gdlr_core_enable_srcset( $enable ){
			$enable_srcset = financity_get_option('plugin', 'enable-srcset', 'disable');
			return ($enable_srcset == 'enable');
		}
	}
			
	// for goodlayers core pagination
	if( !function_exists('financity_gdlr_core_pagination_style') ){
		function financity_gdlr_core_pagination_style( $style ) {
			return financity_get_option('general', 'pagination-style', $style);
		}
	}
	if( !function_exists('financity_gdlr_core_pagination_align') ){
		function financity_gdlr_core_pagination_align( $align ) {
			return financity_get_option('general', 'pagination-align', $align);
		}
	}			

	// custom post type slug
	if( !function_exists('financity_gdlr_core_custom_post_slug') ){
		function financity_gdlr_core_custom_post_slug( $slug, $type = '' ) {
			if( empty($type) ){ $type = $slug; }

			if( $type == 'portfolio' ){
				$slug = financity_get_option('general', 'portfolio-slug', $slug);
			}else if( $type == 'portfolio_category' ){
				$slug = financity_get_option('general', 'portfolio-category-slug', $slug);
			}else if( $type == 'portfolio_tag' ){
				$slug = financity_get_option('general', 'portfolio-tag-slug', $slug);
			}else if( $type == 'personnel' ){
				$slug = financity_get_option('general', 'personnel-slug', $slug);
			}else if( $type == 'personnel_category' ){
				$slug = financity_get_option('general', 'personnel-category-slug', $slug);
			}
			
			return $slug;
		}
	}

	// single portfolio
	if( !function_exists('financity_gdlr_core_portfolio_single_nav') ){
		function financity_gdlr_core_portfolio_single_nav( $check ) {
			return financity_get_option('general', 'enable-single-portfolio-navigation', $check);
		}
	}
	if( !function_exists('financity_gdlr_core_portfolio_single_nav_same_term') ){
		function financity_gdlr_core_portfolio_single_nav_same_term( $check ) {
			return financity_get_option('general', 'enable-single-portfolio-navigation-in-same-tag', $check);
		}
	}
	if( !function_exists('financity_gdlr_core_portfolio_single_related') ){
		function financity_gdlr_core_portfolio_single_related( $args ) {

			$enble_related_portfolio = financity_get_option('general', 'enable-related-portfolio', 'enable');
			if( $enble_related_portfolio == 'enable' ){
				$args['portfolio-style'] = financity_get_option('general', 'related-portfolio-style', 'grid');
				$args['num-fetch'] = financity_get_option('general', 'related-portfolio-num-fetch', 4);
				$args['column-size'] = financity_get_option('general', 'related-portfolio-column-size', 15);
				$args['thumbnail-size'] = financity_get_option('general', 'related-portfolio-thumbnail-size', 'medium');
				$args['excerpt-number'] = financity_get_option('general', 'related-portfolio-num-excerpt', 20);
				$args['column-size'] = financity_get_option('general', 'related-portfolio-column-size', 15);

				return $args;
			}else{
				return array();
			}
		}
	}

	// set default social share option
	if( !function_exists('financity_gdlr_core_social_share_list') ){
		function financity_gdlr_core_social_share_list( $social ) {

			$social['facebook'] = financity_get_option('general', 'blog-social-facebook', $social['facebook']);
			$social['linkedin'] = financity_get_option('general', 'blog-social-linkedin', $social['linkedin']);
			$social['google-plus'] = financity_get_option('general', 'blog-social-google-plus', $social['google-plus']);
			$social['pinterest'] = financity_get_option('general', 'blog-social-pinterest', $social['pinterest']);
			$social['stumbleupon'] = financity_get_option('general', 'blog-social-stumbleupon', $social['stumbleupon']);
			$social['twitter'] = financity_get_option('general', 'blog-social-twitter', $social['twitter']);
			$social['email'] = financity_get_option('general', 'blog-social-email', $social['email']);

			return $social;
		}
	}	

	// add filter to register custom fonts for font lists 
	add_filter('gdlr_core_custom_uploaded_font', 'financity_register_custom_uploaded_font');
	if( !function_exists('financity_register_custom_uploaded_font') ){
		function financity_register_custom_uploaded_font( $custom_fonts ){

			$custom_font = financity_get_option('typography', 'font-upload');
			if( !empty($custom_font) ){
				foreach($custom_font as $font_option){
					$font_option['name'] = str_replace('+', '', $font_option['name']);
					while( !empty($custom_fonts[$font_option['name']]) ){
						$font_option['name'] = $font_option['name'] . '+';
					}

					$custom_fonts[$font_option['name']] = array(
						'eot' => empty($font_option['eot'])? '': $font_option['eot'],
						'ttf' => empty($font_option['ttf'])? '': $font_option['ttf'],
						'woff' => empty($font_option['woff'])? '': $font_option['woff'],
						'font-weight' => empty($font_option['font-weight'])? 'normal': $font_option['font-weight'],
						'font-style' => empty($font_option['font-style'])? 'normal': $font_option['font-style']
					);
				}
			}	
			
			return $custom_fonts;
			
		} // financity_register_custom_uploaded_font
	} // function_exists

	// format widget title
	if( !function_exists('financity_gdlr_core_widget_title_nav') ){
		function financity_gdlr_core_widget_title_nav( $title_nav ){
			return '</span><span class="gdlr-core-flexslider-nav gdlr-core-plain-style gdlr-core-size-widget">';
		}
	}
	
	// add page builder to post
	add_filter('gdlr_core_page_builder_post_type', 'financity_gdlr_core_page_builder_post_type');
	if( !function_exists('financity_gdlr_core_page_builder_post_type') ){
		function financity_gdlr_core_page_builder_post_type( $post_types ){
			$post_types[] = 'post';
			return $post_types;
		}
	}

	// set lightbox type
	add_filter('gdlr_core_lightbox_type', 'financity_gdlr_core_lightbox_type');
	if( !function_exists('financity_gdlr_core_lightbox_type') ){
		function financity_gdlr_core_lightbox_type(){
			$lightbox_type = financity_get_option('plugin', 'lightbox', 'ilightbox');

			if( $lightbox_type == 'ilightbox' ){
				$ilightbox_skin = financity_get_option('plugin', 'ilightbox-skin', 'dark');
				return $lightbox_type . '-' . $ilightbox_skin;
			}else{
				return $lightbox_type;
			}
		}
	}
	add_filter('body_class', 'financity_lightbox_body_class');
	if( !function_exists('financity_lightbox_body_class') ){
		function financity_lightbox_body_class($class){
			$link_to_lightbox = financity_get_option('plugin', 'link-to-lightbox', 'enable');
			if( $link_to_lightbox == 'enable' ){
				$class[] = 'gdlr-core-link-to-lightbox';
			}
			return $class;
		}
	}

	// add breadcrumbs option for portfolio
	add_filter('gdlr_core_portfolio_options', 'financity_gdlr_core_portfolio_options');
	if( !function_exists('financity_gdlr_core_portfolio_options') ){
		function financity_gdlr_core_portfolio_options($options){

			if( !empty($options['general']['options']) ){

				$general_first = array_slice($options['general']['options'], 0, 3, true); 
				$general_last = array_slice($options['general']['options'], 3, NULL, true);

				$options['general']['options'] = array_merge($general_first, array(
					'enable-breadcrumbs' => array(
						'title' => esc_html__('Enable Breadcrumbs ( Breadcrumb NavXT Plugin )', 'financity'),
						'type' => 'combobox',
						'options' => array(
							'default' => esc_html__('Default', 'financity'),
							'enable' => esc_html__('Enable', 'financity'),
							'disable' => esc_html__('Disable', 'financity'),
						),
						'default' => 'default',
						'condition' => array( 'enable-page-title' => 'enable' )
					),
				), $general_last);
			}

			return $options;
		}
	}	
	
	// add page builder pre defined template
	if( is_admin() && class_exists('gdlr_core_page_builder_template') ){
		add_filter('gdlr_core_page_builder_page_template_list', 'financity_gdlr_core_page_builder_page_template_list');
		add_filter('gdlr_core_page_builder_get_page_template', 'financity_gdlr_core_page_builder_get_page_template', 10, 2);
	}

	if( !function_exists('financity_gdlr_core_page_builder_page_template_list') ){
		function financity_gdlr_core_page_builder_page_template_list( $templates ){
			$templates['home1'] = array(
				'title' => esc_html__('Homepage 1', 'financity'),
				'type' => 'wrapper',
			);
			$templates['home2'] = array(
				'title' => esc_html__('Homepage 2', 'financity'),
				'type' => 'wrapper',
			);
			$templates['home3'] = array(
				'title' => esc_html__('Homepage 3', 'financity'),
				'type' => 'wrapper',
			);
			$templates['about1'] = array(
				'title' => esc_html__('About Us 1', 'financity'),
				'type' => 'wrapper',
			);
			$templates['about2'] = array(
				'title' => esc_html__('About Us 2', 'financity'),
				'type' => 'wrapper',
			);
			$templates['about3'] = array(
				'title' => esc_html__('About Us 3', 'financity'),
				'type' => 'wrapper',
			);
			$templates['career'] = array(
				'title' => esc_html__('Career', 'financity'),
				'type' => 'wrapper',
			);
			$templates['single-service'] = array(
				'title' => esc_html__('Single Service', 'financity'),
				'type' => 'wrapper',
			);
			$templates['single-case1'] = array(
				'title' => esc_html__('Single Case 1', 'financity'),
				'type' => 'wrapper',
			);
			$templates['single-case2'] = array(
				'title' => esc_html__('Single Case 2', 'financity'),
				'type' => 'wrapper',
			);
			$templates['single-case3'] = array(
				'title' => esc_html__('Single Case 3', 'financity'),
				'type' => 'wrapper',
			);
			return $templates;
		} // financity_gdlr_core_page_builder_page_template_list
	} // function_exists

	if( !function_exists('financity_gdlr_core_page_builder_get_page_template') ){
		function financity_gdlr_core_page_builder_get_page_template( $value, $type ){

			if( !empty($value) ) return $value; 

			switch( $type ){
				case 'home1': 
					return '[{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"full","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"#172852","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"62px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"revolution-slider","value":{"id":"","class":"","revolution-slider-id":"1","padding-bottom":"0px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"fadeInUp","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"#f5f5f5","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.2","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"76px","right":"0px","bottom":"28px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"Column Service HP 1"},"items":[{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"5485","title":"On Time  <br/>Service.","caption":"","content":"Transforming distribution and marketing with key capabilities in customer insight and analytics.","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"30px","title-size":"22px","title-font-weight":"600","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"14px","content-size":"16px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"10px","right":"30px","bottom":"","left":""},"title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"5486","title":"A Team Of  <br/>Professionals.","caption":"","content":"Transforming distribution and marketing with key capabilities in customer insight and analytics.","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"30px","title-size":"22px","title-font-weight":"600","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"14px","content-size":"16px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"10px","right":"30px","bottom":"","left":""},"title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"5487","title":"Analyze Your  <br/>Business.","caption":"","content":"Transforming distribution and marketing with key capabilities in customer insight and analytics.","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"30px","title-size":"22px","title-font-weight":"600","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"14px","content-size":"16px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"10px","right":"30px","bottom":"","left":""},"title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"5599","background-image-style":"no-repeat","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.08","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"80px","right":"0px","bottom":"80px","left":"0px","settings":"unlink"},"margin":{"top":"30px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Services We Provide","caption":"Covered in these areas","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"44px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"14px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"2px","caption-font-uppercase":"enable","left-icon-color":"","title-color":"#3e4494","title-link-hover-color":"","caption-color":"","caption-spaces":"5px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"40px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"fadeInUp","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"20px","left":"0px","settings":"unlink"},"margin":{"top":"-60px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"hover-box","value":{"id":"","class":"","tabs":[{"image":"5488","image-img":"https://demo.goodlayers.com/financity/wp-content/uploads/2017/08/service-icon-1.png","title":"Capital Markets","content":"Providing insight-driven transformation to investment banks, wealth and asset managers, exchanges, clearing houses.","link":"/financity/capital-markets/"},{"image":"5489","image-img":"https://demo.goodlayers.com/financity/wp-content/uploads/2017/08/service-icon-2.png","title":"Insurance","content":"Providing insight-driven transformation to investment banks, wealth and asset managers, exchanges, clearing houses.","link":"/financity/insurance/"},{"image":"5490","image-img":"https://demo.goodlayers.com/financity/wp-content/uploads/2017/08/service-icon-3.png","title":"Blockchain","content":"Providing insight-driven transformation to investment banks, wealth and asset managers, exchanges, clearing houses.","link":"/financity/blockchain/"},{"image":"5522","image-img":"https://demo.goodlayers.com/financity/wp-content/uploads/2017/08/service-icon-4.png","title":"Technology Advisory","content":"Providing insight-driven transformation to investment banks, wealth and asset managers, exchanges, clearing houses.","link":"/financity/technology-advisory/"},{"image":"5523","image-img":"https://demo.goodlayers.com/financity/wp-content/uploads/2017/08/service-icon-5.png","title":"Finance & Risk","content":"Providing insight-driven transformation to investment banks, wealth and asset managers, exchanges, clearing houses.","link":"/financity/finance-risk/"},{"image":"5524","image-img":"https://demo.goodlayers.com/financity/wp-content/uploads/2017/08/service-icon-6.png","title":"Portfolio Management","content":"Providing insight-driven transformation to investment banks, wealth and asset managers, exchanges, clearing houses.","link":"/financity/portfolio-management/"}],"text-align":"center","image-position":"inside","column":"3","carousel":"disable","carousel-autoslide":"disable","carousel-navigation":"bullet","carousel-nav-style":"default","hover-box-title-size":"","hover-box-title-text-transform":"none","hover-box-title-font-weight":"","hover-box-title-letter-spacing":"","hover-box-title-color":"#f17d44","hover-box-content-color":"#525a70","hover-box-background-color":"","hover-box-background-hover-color":"","shadow-size":{"x":"","y":"","size":"74px","settings":"unlink"},"shadow-color":"#0a0a0a","shadow-opacity":"0.07","hover-box-padding":{"top":"60px","right":"30px","bottom":"35px","left":"30px","settings":"unlink"},"padding-bottom":"30px","title-align":"left","title-left-media":"icon","title-left-icon":"","title-left-image":"","title":"","caption":"","caption-position":"top","read-more-text":"Read More","read-more-link":"","read-more-target":"_self","title-size":"41px","title-letter-spacing":"","title-font-style":"","title-text-transform":"uppercase","caption-size":"16px","caption-font-style":"","read-more-size":"14px","title-left-icon-color":"","title-color":"","caption-color":"","read-more-color":"","read-more-divider-color":"","title-wrap-bottom-margin":"","title-carousel-nav-style":"default"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"fadeInLeft","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"5493","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.2","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"95px","right":"0px","bottom":"65px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"Home CTA"},"items":[{"template":"element","type":"call-to-action","value":{"id":"","class":"","title":"Wanna Talk To Us?","caption":"Please feel free to contact us. We\'re super happy to talk to you. Feel free to ask anything.","button-text":"Contact Us","button-link":"/financity/contact/","button-link-target":"_self","style":"left-align-right-button","button-style":"solid","button-border-radius":"30px","title-size":"48px","title-font-weight":"600","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"20px","caption-letter-spacing":"","padding-bottom":"30px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"5494","background-image-style":"no-repeat","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.04","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"90px","right":"0px","bottom":"20px","left":"0px","settings":"unlink"},"margin":{"top":"10px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Our Cases","caption":"What we have done","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"44px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"14px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"2px","caption-font-uppercase":"enable","left-icon-color":"","title-color":"#3e4494","title-link-hover-color":"","caption-color":"","caption-spaces":"5px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"60px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"full","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"fadeInRight","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"70px","left":"0px","settings":"unlink"},"margin":{"top":"-15px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"Home Cases"},"items":[{"template":"element","type":"portfolio","value":{"id":"","class":"","category":"","tag":"","num-fetch":"6","orderby":"date","order":"desc","filterer":"none","filterer-align":"center","pagination":"none","pagination-style":"default","pagination-align":"default","portfolio-style":"grid-no-space","portfolio-grid-text-align":"left","portfolio-grid-style":"normal","portfolio-frame-opacity":"1","enable-portfolio-tag":"disable","enable-portfolio-date":"disable","portfolio-medium-size":"small","portfolio-medium-style":"left","hover":"margin-icon","column-size":"15","thumbnail-size":"Portfolio Thumbnail Portrait","enable-thumbnail-zoom-on-hover":"enable","enable-thumbnail-grayscale-effect":"disable","enable-badge":"enable","layout":"carousel","carousel-autoslide":"disable","carousel-navigation":"bullet","excerpt":"specify-number","excerpt-number":"55","read-more-button":"enable","overlay-color":"","overlay-opacity":"","portfolio-title-font-size":"21px","portfolio-title-font-weight":"600","portfolio-title-letter-spacing":"0px","portfolio-title-text-transform":"none","portfolio-hover-title-font-size":"18px","portfolio-hover-title-font-weight":"","portfolio-hover-title-letter-spacing":"0px","portfolio-hover-title-text-transform":"none","filterer-bottom-margin":"","portfolio-title-bottom-margin":"","padding-bottom":"40px","title-align":"left","title-left-media":"icon","title-left-icon":"","title-left-image":"","title":"","caption":"","caption-position":"top","read-more-text":"Read More","read-more-link":"","read-more-target":"_self","title-size":"41px","title-letter-spacing":"","title-font-style":"","title-text-transform":"uppercase","caption-size":"16px","caption-font-style":"","read-more-size":"14px","title-left-icon-color":"","title-color":"","caption-color":"","read-more-color":"","read-more-divider-color":"","title-wrap-bottom-margin":"","title-carousel-nav-style":"default"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"View All Cases","link-to":"custom-url","custom-image":"","video-url":"","button-link":"/financity/portfolio-3-columns/","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","text-align":"center","full-width-button":"disable","button-padding":{"top":"17px","right":"38px","bottom":"23px","left":"38px","settings":"unlink"},"border-radius":"33px","button-background":"solid","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text-color":"#ffffff","text-hover-color":"","background-color":"#3740b0","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text2-color":"","text2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","text-size":"15px","text-transform":"none","icon-size":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"full","max-width-wrapper":"1280px","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"#ffffff","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":{"x":"","y":"","size":"74px","settings":"unlink"},"background-shadow-color":"#0a0a0a","background-shadow-opacity":"0.07","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"Purple Personnel"},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"half-height","centering-sync-height-content":"enable","background-type":"image","background-extending":"none","background-color":"#3740b0","background-image":"5496","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"0.7","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.2","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"5498","thumbnail-size":"full","link-to":"lb-video","custom-image":"","video-url":"https://www.youtube.com/watch?v=XygPdx9RwmM","page-id":"5451","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"fadeInRight","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"half-height","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":{"x":"","y":"","size":"0px","settings":"unlink"},"background-shadow-color":"","background-shadow-opacity":"","padding":{"top":"80px","right":"60px","bottom":"60px","left":"80px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"We are trusted by more than 5,000 clients","caption":"Did you know that","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"42px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"15px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"2px","caption-font-uppercase":"enable","left-icon-color":"","title-color":"#4b5091","title-link-hover-color":"","caption-color":"#8085ca","caption-spaces":"10px","media-margin":{"top":"30px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot, which was created for the bliss of souls like mine. More than 25 years of experience working in the industry has enabled us to build our services and solutions in strategy, consulting, digital.","text-align":"left","apply-the-content-filter":"disable","font-size":"16px","text-color":"#8285b3","padding-bottom":"16px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Read Our Story","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","text-align":"left","full-width-button":"disable","button-padding":{"top":"14px","right":"38px","bottom":"19px","left":"38px","settings":"unlink"},"border-radius":"33px","button-background":"transparent","button-border":"enable","border-width":{"top":"2px","right":"2px","bottom":"2px","left":"2px","settings":"link"},"text-color":"#3740b0","text-hover-color":"","background-color":"","background-hover-color":"","background-gradient-color":"","border-color":"#3740b0","border-hover-color":"","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text2-color":"","text2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","text-size":"16px","text-transform":"none","icon-size":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"fadeInLeft","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"half-height-2","centering-sync-height-content":"enable","background-type":"color","background-extending":"none","background-color":"#313787","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"95px","right":"0px","bottom":"55px","left":"80px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"We are an expert in <br/>this field","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"42px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"#ffffff","title-link-hover-color":"","caption-color":"","caption-spaces":"3px","media-margin":{"top":"30px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"10px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Yet I feel that I never was a greater artist than now.<br />\nWhen, while the lovely valley teems.</p>\n","text-align":"left","apply-the-content-filter":"disable","font-size":"19px","text-color":"#93ecf9","padding-bottom":"7px"}},{"template":"element","type":"icon-list","value":{"id":"","class":"","tabs":[{"icon":"icon_check","icon-hover":"","title":"Premium services and beyond your expectation","link-url":""},{"icon":"icon_check","icon-hover":"","title":"Get the best support among all venders","link-url":""},{"icon":"icon_check","icon-hover":"","title":"Fully responsive and works great on all major devices","link-url":""},{"icon":"icon_check","icon-hover":"","title":"Tons of admin panel options","link-url":""}],"columns":"60","enable-divider":"disable","icon-background":"none","icon-color":"#ffffff","icon-background-color":"","content-color":"#a4abfb","border-color":"","icon-size":"16px","content-size":"16px","list-bottom-margin":"7px","padding-bottom":"30px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Read Our Story","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","text-align":"left","full-width-button":"disable","button-padding":{"top":"14px","right":"38px","bottom":"19px","left":"38px","settings":"unlink"},"border-radius":"33px","button-background":"transparent","button-border":"enable","border-width":{"top":"2px","right":"2px","bottom":"2px","left":"2px","settings":"link"},"text-color":"#ffffff","text-hover-color":"","background-color":"","background-hover-color":"","background-gradient-color":"","border-color":"#ffffff","border-hover-color":"","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text2-color":"","text2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","text-size":"16px","text-transform":"none","icon-size":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"half-height-2","centering-sync-height-content":"disable","background-type":"image","background-extending":"none","background-color":"","background-image":"5306","background-image-style":"cover","background-image-position":"top-right","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"custom","max-width-wrapper":"","max-width":"1360px","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"#f2f2f2","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"95px","right":"0px","bottom":"295px","left":"0px","settings":"unlink"},"margin":{"top":"90px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"gallery","value":{"id":"","class":"","gallery":[{"id":"4141","thumbnail":"http://demo.goodlayers.com/financity/wp-content/uploads/2016/11/banner-3.png","link-to":"none","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self"},{"id":"4142","thumbnail":"http://demo.goodlayers.com/financity/wp-content/uploads/2016/11/banner-4.png","link-to":"none","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self"},{"id":"4140","thumbnail":"http://demo.goodlayers.com/financity/wp-content/uploads/2016/11/banner-2.png","link-to":"none","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self"},{"id":"4139","thumbnail":"http://demo.goodlayers.com/financity/wp-content/uploads/2016/11/banner-1.png","link-to":"none","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self"},{"id":"5391","thumbnail":"http://demo.goodlayers.com/financity/wp-content/uploads/2017/06/banner-5-150x43.png","link-to":"none","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self"}],"pagination":"none","show-amount":"20","pagination-style":"default","pagination-align":"default","style":"grid","max-slider-height":"500px","overlay":"none","show-caption":"disable","overlay-on-hover":"disable","column":"5","layout":"carousel","slider-navigation":"navigation","slider-effects":"default","enable-direction-navigation":"disable","thumbnail-navigation":"below-slider","carousel-autoslide":"enable","grid-slider-navigation":"none","thumbnail-size":"full","slider-thumbnail-size":"medium","image-bottom-margin":"","padding-bottom":"30px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"full","max-width-wrapper":"1280px","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"fadeIn","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"#ffffff","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":{"x":"","y":"","size":"73px","settings":"unlink"},"background-shadow-color":"#0a0a0a","background-shadow-opacity":"0.07","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"-235px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"quote-height","centering-sync-height-content":"disable","background-type":"image","background-extending":"none","background-color":"","background-image":"5499","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""}},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"quote-height","centering-sync-height-content":"enable","background-type":"color","background-extending":"none","background-color":"#ffffff","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"70px","right":"60px","bottom":"60px","left":"75px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"blockquote","value":{"id":"","class":"","content":"Our goal is to be at the heart of the financial services industry as businesses expand across.","author":"John Smith","author-position":"CEO Of Financity","text-align":"left","size":"large","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"5502","background-image-style":"no-repeat","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.04","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"110px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Latest News","caption":"","caption-position":"bottom","title-width":"300px","title-link-text":"Read All News","title-link":"/financity/blog-full-right-sidebar-with-frame/","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"44px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"14px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"2px","caption-font-uppercase":"enable","left-icon-color":"","title-color":"#3e4494","title-link-hover-color":"","caption-color":"","caption-spaces":"5px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"55px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"fadeInUp","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"Column Service HP 1"},"items":[{"template":"element","type":"blog","value":{"id":"","class":"","category":"","tag":"","num-fetch":"5","prepend-sticky":"disable","orderby":"date","order":"desc","filterer":"none","filterer-align":"center","pagination":"none","pagination-style":"default","pagination-align":"default","offset":"0","blog-style":"blog-column-with-frame","blog-full-alignment":"left","blog-list-with-frame":"disable","always-show-overlay-content":"disable","show-thumbnail":"enable","thumbnail-size":"Portfolio Thumbnail","enable-thumbnail-opacity-on-hover":"enable","enable-thumbnail-zoom-on-hover":"enable","enable-thumbnail-grayscale-effect":"disable","column-size":"20","layout":"carousel","carousel-autoslide":"enable","carousel-navigation":"bullet","item-size":"small","excerpt":"specify-number","excerpt-number":"21","blog-date-feature":"enable","meta-option":["date","author","category"],"show-read-more":"enable","filterer-bottom-margin":"","blog-title-font-size":"21px","blog-title-font-weight":"600","blog-title-letter-spacing":"0px","blog-title-text-transform":"none","frame-shadow-size":{"x":"","y":"","size":"30px","settings":"unlink"},"frame-shadow-color":"#0a0a0a","frame-shadow-opacity":"0.06","padding-bottom":"60px","title-align":"left","title-left-media":"icon","title-left-icon":"","title-left-image":"","title":"","caption":"","caption-position":"top","read-more-text":"Read More","read-more-link":"","read-more-target":"_self","title-size":"41px","title-letter-spacing":"","title-font-style":"","title-text-transform":"uppercase","caption-size":"16px","caption-font-style":"","read-more-size":"14px","title-left-icon-color":"","title-color":"","caption-color":"","read-more-color":"","read-more-divider-color":"","title-wrap-bottom-margin":"","title-carousel-nav-style":"default"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"custom","max-width-wrapper":"","max-width":"800px","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"5501","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.2","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"130px","right":"0px","bottom":"70px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"HP Testimonial"},"items":[{"template":"element","type":"testimonial","value":{"id":"","class":"","title":"Clients\' Testimonials","title-left-icon":"","caption":"","tabs":[{"title":"John Smith","position":"CEO, Press Mag","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place.","image":"","image-img":"","rating":""},{"title":"Jane Doe","position":"Jounalist","content":"One morning, when Gregor Samsa woke from troubled dreams, he found himself transformed in his bed into a horrible vermin. He lay on his armour-like back, and if he lifted his head a little he could see his brown belly, slightly domed and divided by arches.","image":"","image-img":"","rating":""}],"style":"center","column":"1","enable-quote":"enable","carousel":"enable","carousel-autoslide":"disable","carousel-navigation":"bullet","carousel-nav-style":"default","title-size":"48px","title-text-transform":"none","title-font-weight":"600","title-letter-spacing":"0px","caption-size":"16px","content-size":"20px","title-color":"#ffffff","caption-color":"","quote-color":"#ffffff","content-color":"#c4c8ff","name-color":"#ffffff","position-color":"#acb2ff","title-wrap-bottom-margin":"30px","content-bottom-padding":"0px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"#f0f0f0","background-image":"5389","background-image-style":"no-repeat","background-image-position":"top-center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.04","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"120px","right":"0px","bottom":"120px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"100px","right":"","bottom":"30px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Our Success Stories","caption":"what we have done","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"43px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"14px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"2px","caption-font-uppercase":"enable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"5px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"67px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width-wrapper":"1280px","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"fadeInUp","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"#ffffff","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":{"x":"","y":"","size":"74px","settings":"unlink"},"background-shadow-color":"#141414","background-shadow-opacity":"0.07","padding":{"top":"85px","right":"0px","bottom":"45px","left":"0px","settings":"unlink"},"margin":{"top":"-120px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"0px","right":"","bottom":"","left":"","settings":"unlink"},"skin":"Purple Service"},"items":[{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"15px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"0","end-number":"10000","animation-time":"2000","suffix":"","divider":"disable","bottom-text":"All Time Clients","top-icon-size":"30px","top-text-size":"16px","number-size":"40px","bottom-text-size":"18px","bottom-text-transform":"none","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"0","end-number":"979","animation-time":"2000","suffix":"","divider":"disable","bottom-text":"Clients In This Year","top-icon-size":"30px","top-text-size":"16px","number-size":"40px","bottom-text-size":"18px","bottom-text-transform":"none","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"0","end-number":"300","animation-time":"2000","suffix":"","divider":"disable","bottom-text":"New Projects","top-icon-size":"30px","top-text-size":"16px","number-size":"40px","bottom-text-size":"18px","bottom-text-transform":"none","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"15px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"0","end-number":"35","animation-time":"2000","suffix":"%","divider":"disable","bottom-text":"Avg Profit Increased","top-icon-size":"30px","top-text-size":"16px","number-size":"40px","bottom-text-size":"18px","bottom-text-transform":"none","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"90px","right":"0px","bottom":"60px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"height-contact","centering-sync-height-content":"enable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Request a call back?","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"40px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"#3e4494","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"20px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","icon-size":"15px","divider-size":"3px","divider-width":"60px","padding-bottom":"30px","icon-color":"","divider-color":"#cccccc"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Please fill out the form and press the submit button.<br />\nWe will get back to you with 1-2 business days.</p>\n","text-align":"center","apply-the-content-filter":"disable","font-size":"18px","text-color":"","padding-bottom":"50px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"height-contact","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"contact-form-7","value":{"id":"","class":"","cf7-id":"5503","padding-bottom":"30px"}}]}]}]';
				case 'home2': 
					return '[{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"full","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"#172852","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"58px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"revolution-slider","value":{"id":"","class":"","revolution-slider-id":"1","padding-bottom":"0px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"full","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"#f5f5f5","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.2","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"Column Service HP 1"},"items":[{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"service-height","centering-sync-height-content":"enable","background-type":"image","background-extending":"none","background-color":"","background-image":"5516","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"80px","right":"40px","bottom":"30px","left":"60px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"Hp2 Column Service"},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"5519","title":"On Time  <br/>Service.","caption":"","content":"Transforming distribution and marketing with key capabilities in customer insight and analytics.","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"30px","title-size":"22px","title-font-weight":"600","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"14px","content-size":"17px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"10px","right":"30px","bottom":"","left":""},"title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"service-height","centering-sync-height-content":"enable","background-type":"image","background-extending":"none","background-color":"","background-image":"5517","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"80px","right":"40px","bottom":"30px","left":"60px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"Hp2 Column Service"},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"5520","title":"A Team Of  <br/>Professionals.","caption":"","content":"Transforming distribution and marketing with key capabilities in customer insight and analytics.","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"30px","title-size":"22px","title-font-weight":"600","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"14px","content-size":"17px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"10px","right":"30px","bottom":"","left":""},"title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"service-height","centering-sync-height-content":"enable","background-type":"image","background-extending":"none","background-color":"","background-image":"5518","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"80px","right":"40px","bottom":"30px","left":"60px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"Hp2 Column Service 2"},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"5521","title":"Analyze Your  <br/>Business.","caption":"","content":"Transforming distribution and marketing with key capabilities in customer insight and analytics.","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"30px","title-size":"22px","title-font-weight":"600","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"14px","content-size":"17px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"10px","right":"30px","bottom":"","left":""},"title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"","background-image-style":"no-repeat","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.04","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"60px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"30px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Services We Provide","caption":"Covered in these areas","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"44px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"14px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"2px","caption-font-uppercase":"enable","left-icon-color":"","title-color":"#232323","title-link-hover-color":"","caption-color":"","caption-spaces":"5px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"27px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","icon-size":"15px","divider-size":"4px","divider-width":"54px","padding-bottom":"25px","icon-color":"","divider-color":"#254099"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"160px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"hover-box","value":{"id":"","class":"","tabs":[{"image":"5525","image-img":"https://demo.goodlayers.com/financity/wp-content/uploads/2017/09/hp2-service-1.jpg","title":"Capital Markets","content":"Providing insight-driven transformation to investment banks, wealth and asset managers, exchanges, clearing houses.","link":"/financity/capital-markets/"},{"image":"5526","image-img":"https://demo.goodlayers.com/financity/wp-content/uploads/2017/09/hp2-service-2.jpg","title":"Insurance","content":"Providing insight-driven transformation to investment banks, wealth and asset managers, exchanges, clearing houses.","link":"/financity/insurance/"},{"image":"5527","image-img":"https://demo.goodlayers.com/financity/wp-content/uploads/2017/09/hp2-service-3.jpg","title":"Blockchain","content":"Providing insight-driven transformation to investment banks, wealth and asset managers, exchanges, clearing houses.","link":"/financity/blockchain/"},{"image":"5528","image-img":"https://demo.goodlayers.com/financity/wp-content/uploads/2017/09/hp2-service-4.jpg","title":"Technology Advisory","content":"Providing insight-driven transformation to investment banks, wealth and asset managers, exchanges, clearing houses.","link":"/financity/technology-advisory/"},{"image":"5529","image-img":"https://demo.goodlayers.com/financity/wp-content/uploads/2017/09/hp2-service-5.jpg","title":"Finance & Risk","content":"Providing insight-driven transformation to investment banks, wealth and asset managers, exchanges, clearing houses.","link":"/financity/finance-risk/"},{"image":"5530","image-img":"https://demo.goodlayers.com/financity/wp-content/uploads/2017/09/hp2-service-6.jpg","title":"Portfolio Management","content":"Providing insight-driven transformation to investment banks, wealth and asset managers, exchanges, clearing houses.","link":"/financity/portfolio-management/"}],"text-align":"left","image-position":"top","column":"3","carousel":"disable","carousel-autoslide":"disable","carousel-navigation":"bullet","carousel-nav-style":"default","hover-box-title-size":"20px","hover-box-title-text-transform":"none","hover-box-title-font-weight":"","hover-box-title-letter-spacing":"","hover-box-title-color":"#254099","hover-box-content-color":"#898989","hover-box-background-color":"","hover-box-background-hover-color":"","shadow-size":{"x":"","y":"","size":"74px","settings":"unlink"},"shadow-color":"#0a0a0a","shadow-opacity":"0.07","hover-box-padding":{"top":"","right":"","bottom":"","left":"35px","settings":"unlink"},"padding-bottom":"20px","title-align":"left","title-left-media":"icon","title-left-icon":"","title-left-image":"","title":"","caption":"","caption-position":"top","read-more-text":"Read More","read-more-link":"","read-more-target":"_self","title-size":"41px","title-letter-spacing":"","title-font-style":"","title-text-transform":"uppercase","caption-size":"16px","caption-font-style":"","read-more-size":"14px","title-left-icon-color":"","title-color":"","caption-color":"","read-more-color":"","read-more-divider-color":"","title-wrap-bottom-margin":"","title-carousel-nav-style":"default"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"5531","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.1","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"110px","right":"0px","bottom":"225px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"Hp2 Column Service"},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"10px","left":"0px","settings":"unlink"},"margin":{"top":"-210px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"5532","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"5514","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"round","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"30px"}}]},{"template":"element","type":"title","value":{"id":"","class":"","title":"Something About Us","caption":"Our Little Story","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"44px","title-font-weight":"700","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"15px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"1px","caption-font-uppercase":"enable","left-icon-color":"","title-color":"#ffffff","title-link-hover-color":"","caption-color":"#a4a8db","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"columnize","value":{"id":"","class":"","column-number":"2","content":"A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot, which was created for the bliss of souls like mine. I am so happy, my dear friend, so absorbed in the wind I should be incapable of drawing a single stroke at the present moment; and yet I feel that I never was a greater artist than now. When, while the lovely valley teems with vapour around me, and the meridian. I throw myself down among the tall grass by the trickling stream; and.","font-size":"19px","border-size":"0px","border-color":"#e0e0e0","column-gap":"50px","padding-bottom":"20px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"-160px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"Purple Personnel"},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"half-height","centering-sync-height-content":"enable","background-type":"image","background-extending":"none","background-color":"#112f90","background-image":"5316","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"0.6","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"5498","thumbnail-size":"full","link-to":"lb-video","custom-image":"","video-url":"https://www.youtube.com/watch?v=XygPdx9RwmM","page-id":"5451","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"half-height","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"#ffffff","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":{"x":"","y":"","size":"74px","settings":"unlink"},"background-shadow-color":"#0c0c0c","background-shadow-opacity":"0.07","padding":{"top":"80px","right":"40px","bottom":"60px","left":"50px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"We are trusted by more than 5,000 clients","caption":"Did you know that","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"43px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"15px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"2px","caption-font-uppercase":"enable","left-icon-color":"","title-color":"#254099","title-link-hover-color":"","caption-color":"#7e8bc9","caption-spaces":"10px","media-margin":{"top":"30px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot, which was created for the bliss of souls like mine. More than 25 years of experience working in the industry has enabled us to build our services and solutions in strategy, consulting, digital.</p>","text-align":"left","apply-the-content-filter":"disable","font-size":"17px","text-color":"#8285b3","padding-bottom":"16px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Read Our Story","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","text-align":"left","full-width-button":"disable","button-padding":{"top":"14px","right":"38px","bottom":"19px","left":"38px","settings":"unlink"},"border-radius":"33px","button-background":"transparent","button-border":"enable","border-width":{"top":"2px","right":"2px","bottom":"2px","left":"2px","settings":"link"},"text-color":"#254099","text-hover-color":"","background-color":"","background-hover-color":"","background-gradient-color":"","border-color":"#254099","border-hover-color":"","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text2-color":"","text2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","text-size":"16px","text-transform":"none","icon-size":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"half-height-2","centering-sync-height-content":"enable","background-type":"color","background-extending":"none","background-color":"#232323","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"95px","right":"0px","bottom":"55px","left":"65px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"We are an expert in <br/>this field","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"42px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"#ffffff","title-link-hover-color":"","caption-color":"","caption-spaces":"3px","media-margin":{"top":"30px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"10px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Yet I feel that I never was a greater artist than now.<br />\nWhen, while the lovely valley teems.</p>\n","text-align":"left","apply-the-content-filter":"disable","font-size":"20px","text-color":"#ffffff","padding-bottom":"7px"}},{"template":"element","type":"icon-list","value":{"id":"","class":"","tabs":[{"icon":"icon_check","icon-hover":"","title":"Premium services and beyond your expectation","link-url":""},{"icon":"icon_check","icon-hover":"","title":"Get the best support among all venders","link-url":""},{"icon":"icon_check","icon-hover":"","title":"Fully responsive and works great on all major devices","link-url":""},{"icon":"icon_check","icon-hover":"","title":"Tons of admin panel options","link-url":""}],"columns":"60","enable-divider":"disable","icon-background":"none","icon-color":"#ffffff","icon-background-color":"","content-color":"#bcbcbc","border-color":"","icon-size":"17px","content-size":"17px","list-bottom-margin":"10px","padding-bottom":"30px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Read Our Story","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","text-align":"left","full-width-button":"disable","button-padding":{"top":"14px","right":"38px","bottom":"19px","left":"38px","settings":"unlink"},"border-radius":"33px","button-background":"solid","button-border":"disable","border-width":{"top":"2px","right":"2px","bottom":"2px","left":"2px","settings":"link"},"text-color":"#254099","text-hover-color":"","background-color":"#ffffff","background-hover-color":"","background-gradient-color":"","border-color":"#ffffff","border-hover-color":"","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text2-color":"","text2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","text-size":"16px","text-transform":"none","icon-size":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"half-height-2","centering-sync-height-content":"disable","background-type":"image","background-extending":"none","background-color":"","background-image":"5533","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"","background-image-style":"no-repeat","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.04","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"90px","right":"0px","bottom":"20px","left":"0px","settings":"unlink"},"margin":{"top":"10px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Our Cases","caption":"","caption-position":"bottom","title-width":"300px","title-link-text":"View All Works","title-link":"/financity/demo2/portfolio-3-columns/","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"44px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"14px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"2px","caption-font-uppercase":"enable","left-icon-color":"","title-color":"#212121","title-link-hover-color":"","caption-color":"","caption-spaces":"1px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"26px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","icon-size":"15px","divider-size":"4px","divider-width":"54px","padding-bottom":"55px","icon-color":"","divider-color":"#254099"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"full","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"#1a3385","background-image":"5534","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"0.06","pattern-opacity":"1","parallax-speed":"0.1","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"20px","left":"0px","settings":"unlink"},"margin":{"top":"-15px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"Hp2 Cases"},"items":[{"template":"element","type":"portfolio","value":{"id":"","class":"","category":"","tag":"","num-fetch":"6","orderby":"date","order":"desc","filterer":"none","filterer-align":"center","pagination":"none","pagination-style":"default","pagination-align":"default","portfolio-style":"grid-no-space","portfolio-grid-text-align":"left","portfolio-grid-style":"normal","portfolio-frame-opacity":"1","enable-portfolio-tag":"disable","enable-portfolio-date":"disable","portfolio-medium-size":"small","portfolio-medium-style":"left","hover":"margin-icon","column-size":"15","thumbnail-size":"Portfolio Thumbnail Portrait","enable-thumbnail-zoom-on-hover":"enable","enable-thumbnail-grayscale-effect":"disable","enable-badge":"enable","layout":"carousel","carousel-autoslide":"disable","carousel-navigation":"bullet","excerpt":"specify-number","excerpt-number":"55","read-more-button":"enable","overlay-color":"","overlay-opacity":"","portfolio-title-font-size":"21px","portfolio-title-font-weight":"600","portfolio-title-letter-spacing":"0px","portfolio-title-text-transform":"none","portfolio-hover-title-font-size":"18px","portfolio-hover-title-font-weight":"","portfolio-hover-title-letter-spacing":"0px","portfolio-hover-title-text-transform":"none","filterer-bottom-margin":"","portfolio-title-bottom-margin":"","padding-bottom":"40px","title-align":"left","title-left-media":"icon","title-left-icon":"","title-left-image":"","title":"","caption":"","caption-position":"top","read-more-text":"Read More","read-more-link":"","read-more-target":"_self","title-size":"41px","title-letter-spacing":"","title-font-style":"","title-text-transform":"uppercase","caption-size":"16px","caption-font-style":"","read-more-size":"14px","title-left-icon-color":"","title-color":"","caption-color":"","read-more-color":"","read-more-divider-color":"","title-wrap-bottom-margin":"","title-carousel-nav-style":"default"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"no-repeat","background-image-position":"top-center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.04","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"90px","right":"0px","bottom":"5px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"100px","right":"","bottom":"30px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Success Stories","caption":"what we have done","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"43px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"14px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"2px","caption-font-uppercase":"enable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"5px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"67px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width-wrapper":"1280px","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"#ffffff","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":{"x":"","y":"","size":"74px","settings":"unlink"},"background-shadow-color":"#141414","background-shadow-opacity":"0.07","padding":{"top":"85px","right":"0px","bottom":"45px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"0px","right":"","bottom":"","left":"","settings":"unlink"},"skin":"Purple Service"},"items":[{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"15px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"0","end-number":"10000","animation-time":"2000","suffix":"","divider":"disable","bottom-text":"All Time Clients","top-icon-size":"30px","top-text-size":"16px","number-size":"40px","bottom-text-size":"18px","bottom-text-transform":"none","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"0","end-number":"979","animation-time":"2000","suffix":"","divider":"disable","bottom-text":"Clients In This Year","top-icon-size":"30px","top-text-size":"16px","number-size":"40px","bottom-text-size":"18px","bottom-text-transform":"none","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"0","end-number":"300","animation-time":"2000","suffix":"","divider":"disable","bottom-text":"New Projects","top-icon-size":"30px","top-text-size":"16px","number-size":"40px","bottom-text-size":"18px","bottom-text-transform":"none","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"15px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"0","end-number":"35","animation-time":"2000","suffix":"%","divider":"disable","bottom-text":"Avg Profit Increased","top-icon-size":"30px","top-text-size":"16px","number-size":"40px","bottom-text-size":"18px","bottom-text-transform":"none","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"full","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"#f3f3f3","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":{"x":"","y":"","size":"","settings":"unlink"},"background-shadow-color":"","background-shadow-opacity":"","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"quote-height","centering-sync-height-content":"disable","background-type":"image","background-extending":"none","background-color":"#0a0a0a","background-image":"5499","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"0.9","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""}},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"500px","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"quote-height","centering-sync-height-content":"enable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"90px","right":"30px","bottom":"80px","left":"75px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"blockquote","value":{"id":"","class":"","content":"Our goal is to be at the heart of the financial services industry as businesses expand across the globe.","author":"John Smith","author-position":"CEO Of Financity","text-align":"left","size":"large","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"","background-image-style":"no-repeat","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.04","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"95px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Latest News","caption":"","caption-position":"bottom","title-width":"300px","title-link-text":"Read All News","title-link":"/financity/demo2/blog-full-right-sidebar-with-frame/","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"44px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"14px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"2px","caption-font-uppercase":"enable","left-icon-color":"","title-color":"#262626","title-link-hover-color":"","caption-color":"","caption-spaces":"5px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"25px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","icon-size":"15px","divider-size":"4px","divider-width":"54px","padding-bottom":"42px","icon-color":"","divider-color":"#254099"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"Hp2 Blog"},"items":[{"template":"element","type":"blog","value":{"id":"","class":"","category":"","tag":"","num-fetch":"5","prepend-sticky":"disable","orderby":"date","order":"desc","filterer":"none","filterer-align":"center","pagination":"none","pagination-style":"default","pagination-align":"default","offset":"0","blog-style":"blog-column-with-frame","blog-full-alignment":"left","blog-list-with-frame":"disable","always-show-overlay-content":"disable","show-thumbnail":"enable","thumbnail-size":"full","enable-thumbnail-opacity-on-hover":"enable","enable-thumbnail-zoom-on-hover":"enable","enable-thumbnail-grayscale-effect":"disable","column-size":"20","layout":"carousel","carousel-autoslide":"enable","carousel-navigation":"bullet","item-size":"small","excerpt":"specify-number","excerpt-number":"0","blog-date-feature":"enable","meta-option":["date"],"show-read-more":"enable","filterer-bottom-margin":"","blog-title-font-size":"18px","blog-title-font-weight":"600","blog-title-letter-spacing":"0px","blog-title-text-transform":"none","frame-shadow-size":{"x":"","y":"","size":"30px","settings":"unlink"},"frame-shadow-color":"#0a0a0a","frame-shadow-opacity":"0.07","padding-bottom":"60px","title-align":"left","title-left-media":"icon","title-left-icon":"","title-left-image":"","title":"","caption":"","caption-position":"top","read-more-text":"Read More","read-more-link":"","read-more-target":"_self","title-size":"41px","title-letter-spacing":"","title-font-style":"","title-text-transform":"uppercase","caption-size":"16px","caption-font-style":"","read-more-size":"14px","title-left-icon-color":"","title-color":"","caption-color":"","read-more-color":"","read-more-divider-color":"","title-wrap-bottom-margin":"","title-carousel-nav-style":"default"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"custom","max-width-wrapper":"","max-width":"800px","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"#1e3181","background-image":"5535","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.2","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"130px","right":"0px","bottom":"70px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"HP Testimonial"},"items":[{"template":"element","type":"testimonial","value":{"id":"","class":"","title":"Clients\' Testimonials","title-left-icon":"","caption":"","tabs":[{"title":"John Smith","position":"CEO, Press Mag","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place and supplies it with the necessary.","image":"","image-img":"","rating":""},{"title":"Jane Doe","position":"Jounalist","content":"One morning, when Gregor Samsa woke from troubled dreams, he found himself transformed in his bed into a horrible vermin. He lay on his armour-like back, and if he lifted his head a little he could see his brown belly, slightly domed and divided by arches into stiff sections. The bedding was hardly.","image":"","image-img":"","rating":""}],"style":"center","column":"1","enable-quote":"enable","carousel":"enable","carousel-autoslide":"disable","carousel-navigation":"bullet","carousel-nav-style":"default","title-size":"48px","title-text-transform":"none","title-font-weight":"600","title-letter-spacing":"0px","caption-size":"16px","content-size":"21px","title-color":"#ffffff","caption-color":"","quote-color":"#ffffff","content-color":"#c4c8ff","name-color":"#ffffff","position-color":"#acb2ff","title-wrap-bottom-margin":"30px","content-bottom-padding":"0px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"90px","right":"0px","bottom":"60px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"height-contact","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Request a call back?","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"38px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"#2d2d2d","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"25px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"left","icon-size":"15px","divider-size":"3px","divider-width":"55px","padding-bottom":"30px","icon-color":"","divider-color":"#254099"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Please fill out the form and press the submit button.<br />\nWe will get back to you with 1-2 business days.</p>\n","text-align":"left","apply-the-content-filter":"disable","font-size":"19px","text-color":"","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"height-contact","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"contact-form-7","value":{"id":"","class":"","cf7-id":"5503","padding-bottom":"20px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"custom","max-width-wrapper":"","max-width":"1360px","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"#f2f2f2","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"70px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"gallery","value":{"id":"","class":"","gallery":[{"id":"4141","thumbnail":"http://demo.goodlayers.com/financity/wp-content/uploads/2016/11/banner-3.png","link-to":"none","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self"},{"id":"4142","thumbnail":"http://demo.goodlayers.com/financity/wp-content/uploads/2016/11/banner-4.png","link-to":"none","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self"},{"id":"4140","thumbnail":"http://demo.goodlayers.com/financity/wp-content/uploads/2016/11/banner-2.png","link-to":"none","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self"},{"id":"4139","thumbnail":"http://demo.goodlayers.com/financity/wp-content/uploads/2016/11/banner-1.png","link-to":"none","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self"},{"id":"5391","thumbnail":"http://demo.goodlayers.com/financity/wp-content/uploads/2017/06/banner-5-150x43.png","link-to":"none","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self"}],"pagination":"none","show-amount":"20","pagination-style":"default","pagination-align":"default","style":"grid","max-slider-height":"500px","overlay":"none","show-caption":"disable","overlay-on-hover":"disable","column":"5","layout":"carousel","slider-navigation":"navigation","slider-effects":"default","enable-direction-navigation":"disable","thumbnail-navigation":"below-slider","carousel-autoslide":"enable","grid-slider-navigation":"none","thumbnail-size":"full","slider-thumbnail-size":"medium","image-bottom-margin":"","padding-bottom":"30px"}}]}]';
				case 'home3': 
					return '[{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"full","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"#21365e","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"revolution-slider","value":{"id":"","class":"","revolution-slider-id":"1","padding-bottom":"0px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"fadeInUp","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"#ffffff","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.2","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"85px","right":"0px","bottom":"28px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"Hp3 Service"},"items":[{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"5541","title":"On Time Service.","caption":"","content":"Transforming distribution and marketing with key capabilities in customer insight and analytics.","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"30px","title-size":"18px","title-font-weight":"600","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"14px","content-size":"16px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"10px","right":"30px","bottom":"","left":""},"title-top-padding":"","title-bottom-margin":"12px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"5542","title":"A Team Of Professionals.","caption":"","content":"Transforming distribution and marketing with key capabilities in customer insight and analytics.","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"30px","title-size":"18px","title-font-weight":"600","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"14px","content-size":"16px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"10px","right":"30px","bottom":"","left":""},"title-top-padding":"","title-bottom-margin":"12px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"5543","title":"Analyze Your Business.","caption":"","content":"Transforming distribution and marketing with key capabilities in customer insight and analytics.","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"30px","title-size":"18px","title-font-weight":"600","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"14px","content-size":"16px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"10px","right":"30px","bottom":"","left":""},"title-top-padding":"","title-bottom-margin":"12px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"5544","title":"Strong Connection.","caption":"","content":"Transforming distribution and marketing with key capabilities in customer insight and analytics.","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"30px","title-size":"18px","title-font-weight":"600","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"14px","content-size":"16px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"10px","right":"30px","bottom":"","left":""},"title-top-padding":"","title-bottom-margin":"12px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"5545","title":"Advanced Technology.","caption":"","content":"Transforming distribution and marketing with key capabilities in customer insight and analytics.","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"30px","title-size":"18px","title-font-weight":"600","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"14px","content-size":"16px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"10px","right":"30px","bottom":"","left":""},"title-top-padding":"","title-bottom-margin":"12px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"5546","title":"National Bank Authorized.","caption":"","content":"Transforming distribution and marketing with key capabilities in customer insight and analytics.","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"30px","title-size":"18px","title-font-weight":"600","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"14px","content-size":"16px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"10px","right":"30px","bottom":"","left":""},"title-top-padding":"","title-bottom-margin":"12px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"full","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"fadeInLeft","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"service-h-1","centering-sync-height-content":"enable","background-type":"image","background-extending":"none","background-color":"#1c1c1c","background-image":"5312","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"0.15","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"135px","right":"60px","bottom":"70px","left":"80px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Business & Financial Consult","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"23px","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"#7aa9ff","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"24px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot.","text-align":"left","apply-the-content-filter":"disable","font-size":"17px","text-color":"#c3c3c3","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"service-h-1","centering-sync-height-content":"enable","background-type":"image","background-extending":"none","background-color":"","background-image":"5533","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""}},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"service-h-1","centering-sync-height-content":"enable","background-type":"color","background-extending":"none","background-color":"#2d5fde","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"5547","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"5539","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"20px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Consulting","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"18px","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"#ffffff","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"0px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"full","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"service-h-1","centering-sync-height-content":"enable","background-type":"image","background-extending":"none","background-color":"","background-image":"5548","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""}},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"service-h-1","centering-sync-height-content":"enable","background-type":"color","background-extending":"none","background-color":"#ffffff","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"5549","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"5539","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"20px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Analyzing","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"18px","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"#212121","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"fadeInRight","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"service-h-1","centering-sync-height-content":"enable","background-type":"image","background-extending":"none","background-color":"#1c1c1c","background-image":"5496","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"0.17","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"135px","right":"60px","bottom":"70px","left":"80px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Analyze The Opportunities","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"23px","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"#7aa9ff","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"24px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot.","text-align":"left","apply-the-content-filter":"disable","font-size":"17px","text-color":"#c3c3c3","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"full","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"fadeInLeft","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"service-h-1","centering-sync-height-content":"enable","background-type":"image","background-extending":"none","background-color":"#1c1c1c","background-image":"5306","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"0.15","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"135px","right":"60px","bottom":"70px","left":"80px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Find Your New S Curve","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"23px","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"#7aa9ff","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"24px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot.","text-align":"left","apply-the-content-filter":"disable","font-size":"17px","text-color":"#c3c3c3","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"service-h-1","centering-sync-height-content":"enable","background-type":"color","background-extending":"none","background-color":"#1b1b1b","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"5551","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"5539","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"20px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Consulting","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"18px","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"#ffffff","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"service-h-1","centering-sync-height-content":"enable","background-type":"image","background-extending":"none","background-color":"","background-image":"5390","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.05","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"5491","background-image-style":"no-repeat","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.04","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"70px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"30px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Services We Provide","caption":"Covered in these areas","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"46px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"14px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"2px","caption-font-uppercase":"enable","left-icon-color":"","title-color":"#242424","title-link-hover-color":"","caption-color":"","caption-spaces":"5px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"60px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"fadeInUp","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"25px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"5305","thumbnail-size":"full","link-to":"page-url","custom-image":"","video-url":"","page-id":"5451","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"round","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"30px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Capital Markets","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"/financity/demo3/capital-markets/","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"20px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"#1e1e1e","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"17px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Providing insight-driven transformation to investment banks, wealth and asset managers, exchanges, clearing houses.","text-align":"left","apply-the-content-filter":"disable","font-size":"16px","text-color":"","padding-bottom":"0px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Learn More","link-to":"custom-url","custom-image":"","video-url":"","button-link":"/financity/demo3/capital-markets/","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","text-align":"left","full-width-button":"disable","button-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"border-radius":"0px","button-background":"transparent","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text-color":"#2d5fde","text-hover-color":"#0d48dd","background-color":"","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text2-color":"","text2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","text-size":"16px","text-transform":"none","icon-size":"","button2-left-margin":"9px","item-top-margin":"-6px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"5526","thumbnail-size":"full","link-to":"page-url","custom-image":"","video-url":"","page-id":"5449","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"round","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"30px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Insurance","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"/financity/demo3/insurance/","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"20px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"#1e1e1e","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"17px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Providing insight-driven transformation to investment banks, wealth and asset managers, exchanges, clearing houses.","text-align":"left","apply-the-content-filter":"disable","font-size":"16px","text-color":"","padding-bottom":"0px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Learn More","link-to":"custom-url","custom-image":"","video-url":"","button-link":"/financity/demo3/insurance/","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","text-align":"left","full-width-button":"disable","button-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"border-radius":"0px","button-background":"transparent","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text-color":"#2d5fde","text-hover-color":"#0d48dd","background-color":"","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text2-color":"","text2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","text-size":"16px","text-transform":"none","icon-size":"","button2-left-margin":"9px","item-top-margin":"-6px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"5527","thumbnail-size":"full","link-to":"page-url","custom-image":"","video-url":"","page-id":"5447","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"round","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"30px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Blockchain","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"/financity/demo3/blockchain/","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"20px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"#1e1e1e","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"17px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Providing insight-driven transformation to investment banks, wealth and asset managers, exchanges, clearing houses.","text-align":"left","apply-the-content-filter":"disable","font-size":"16px","text-color":"","padding-bottom":"0px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Learn More","link-to":"custom-url","custom-image":"","video-url":"","button-link":"/financity/demo3/blockchain/","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","text-align":"left","full-width-button":"disable","button-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"border-radius":"0px","button-background":"transparent","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text-color":"#2d5fde","text-hover-color":"#0d48dd","background-color":"","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text2-color":"","text2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","text-size":"16px","text-transform":"none","icon-size":"","button2-left-margin":"9px","item-top-margin":"-6px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"5528","thumbnail-size":"full","link-to":"page-url","custom-image":"","video-url":"","page-id":"5445","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"round","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"30px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Technology Advisory","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"/financity/demo3/technology-advisory/","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"20px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"#1e1e1e","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"17px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Providing insight-driven transformation to investment banks, wealth and asset managers, exchanges, clearing houses.","text-align":"left","apply-the-content-filter":"disable","font-size":"","text-color":"","padding-bottom":"0px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Learn More","link-to":"custom-url","custom-image":"","video-url":"","button-link":"/financity/demo3/technology-advisory/","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","text-align":"left","full-width-button":"disable","button-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"border-radius":"0px","button-background":"transparent","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text-color":"#2d5fde","text-hover-color":"#0d48dd","background-color":"","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text2-color":"","text2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","text-size":"16px","text-transform":"none","icon-size":"","button2-left-margin":"9px","item-top-margin":"-6px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"5529","thumbnail-size":"full","link-to":"page-url","custom-image":"","video-url":"","page-id":"5437","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"round","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"30px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Finance & Risk","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"/financity/demo3/finance-risk/","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"20px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"#1e1e1e","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"17px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Providing insight-driven transformation to investment banks, wealth and asset managers, exchanges, clearing houses.","text-align":"left","apply-the-content-filter":"disable","font-size":"","text-color":"","padding-bottom":"0px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Learn More","link-to":"custom-url","custom-image":"","video-url":"","button-link":"/financity/demo3/finance-risk/","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","text-align":"left","full-width-button":"disable","button-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"border-radius":"0px","button-background":"transparent","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text-color":"#2d5fde","text-hover-color":"#0d48dd","background-color":"","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text2-color":"","text2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","text-size":"16px","text-transform":"none","icon-size":"","button2-left-margin":"9px","item-top-margin":"-6px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"5530","thumbnail-size":"full","link-to":"page-url","custom-image":"","video-url":"","page-id":"5327","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"round","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"30px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Portfolio Management","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"/financity/demo3/portfolio-management/","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"20px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"#1e1e1e","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"17px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Providing insight-driven transformation to investment banks, wealth and asset managers, exchanges, clearing houses.","text-align":"left","apply-the-content-filter":"disable","font-size":"","text-color":"","padding-bottom":"0px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Learn More","link-to":"custom-url","custom-image":"","video-url":"","button-link":"/financity/demo3/portfolio-management/","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","text-align":"left","full-width-button":"disable","button-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"border-radius":"0px","button-background":"transparent","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text-color":"#2d5fde","text-hover-color":"#0d48dd","background-color":"","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text2-color":"","text2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","text-size":"16px","text-transform":"none","icon-size":"","button2-left-margin":"9px","item-top-margin":"-6px","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"fadeIn","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"5552","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.1","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"75px","right":"0px","bottom":"45px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"Home CTA"},"items":[{"template":"element","type":"call-to-action","value":{"id":"","class":"","title":"Wanna Talk To Us?","caption":"Please feel free to contact us. We\'re super happy to talk to you. Feel free to ask anything.","button-text":"Contact Us","button-link":"/financity/contact/","button-link-target":"_self","style":"left-align-right-button","button-style":"solid","button-border-radius":"30px","title-size":"31px","title-font-weight":"400","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"19px","caption-letter-spacing":"","padding-bottom":"30px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"#f0f0f0","background-image":"5389","background-image-style":"no-repeat","background-image-position":"top-center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.1","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"100px","right":"0px","bottom":"120px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"100px","right":"","bottom":"30px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Our Success Stories","caption":"what we have done","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"43px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"14px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"2px","caption-font-uppercase":"enable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"5px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"67px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width-wrapper":"1280px","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"fadeInUp","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"#ffffff","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":{"x":"","y":"","size":"74px","settings":"unlink"},"background-shadow-color":"#141414","background-shadow-opacity":"0.07","padding":{"top":"85px","right":"0px","bottom":"45px","left":"0px","settings":"unlink"},"margin":{"top":"-120px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"0px","right":"","bottom":"","left":"","settings":"unlink"},"skin":"Hp3 Stats"},"items":[{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"15px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"0","end-number":"10000","animation-time":"2000","suffix":"","divider":"disable","bottom-text":"All Time Clients","top-icon-size":"30px","top-text-size":"16px","number-size":"40px","bottom-text-size":"18px","bottom-text-transform":"none","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"0","end-number":"979","animation-time":"2000","suffix":"","divider":"disable","bottom-text":"Clients In This Year","top-icon-size":"30px","top-text-size":"16px","number-size":"40px","bottom-text-size":"18px","bottom-text-transform":"none","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"0","end-number":"300","animation-time":"2000","suffix":"","divider":"disable","bottom-text":"New Projects","top-icon-size":"30px","top-text-size":"16px","number-size":"40px","bottom-text-size":"18px","bottom-text-transform":"none","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"15px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"0","end-number":"35","animation-time":"2000","suffix":"%","divider":"disable","bottom-text":"Avg Profit Increased","top-icon-size":"30px","top-text-size":"16px","number-size":"40px","bottom-text-size":"18px","bottom-text-transform":"none","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"","background-image-style":"no-repeat","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"80px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"10px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Our Cases","caption":"What we have done","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"45px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"14px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"2px","caption-font-uppercase":"enable","left-icon-color":"","title-color":"#232323","title-link-hover-color":"","caption-color":"","caption-spaces":"5px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"60px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"enable","hide-this-wrapper-in":"none","animation":"fadeInUp","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"60px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"Hp3 Cases"},"items":[{"template":"element","type":"portfolio","value":{"id":"","class":"","category":"","tag":"","num-fetch":"6","orderby":"date","order":"desc","filterer":"none","filterer-align":"center","pagination":"none","pagination-style":"default","pagination-align":"default","portfolio-style":"grid","portfolio-grid-text-align":"left","portfolio-grid-style":"normal","portfolio-frame-opacity":"1","enable-portfolio-tag":"disable","enable-portfolio-date":"disable","portfolio-medium-size":"small","portfolio-medium-style":"left","hover":"margin-icon","column-size":"15","thumbnail-size":"Portfolio Thumbnail Portrait","enable-thumbnail-zoom-on-hover":"enable","enable-thumbnail-grayscale-effect":"disable","enable-badge":"enable","layout":"carousel","carousel-autoslide":"disable","carousel-navigation":"bullet","excerpt":"specify-number","excerpt-number":"55","read-more-button":"enable","overlay-color":"","overlay-opacity":"","portfolio-title-font-size":"21px","portfolio-title-font-weight":"600","portfolio-title-letter-spacing":"0px","portfolio-title-text-transform":"none","portfolio-hover-title-font-size":"18px","portfolio-hover-title-font-weight":"","portfolio-hover-title-letter-spacing":"0px","portfolio-hover-title-text-transform":"none","filterer-bottom-margin":"","portfolio-title-bottom-margin":"","padding-bottom":"40px","title-align":"left","title-left-media":"icon","title-left-icon":"","title-left-image":"","title":"","caption":"","caption-position":"top","read-more-text":"Read More","read-more-link":"","read-more-target":"_self","title-size":"41px","title-letter-spacing":"","title-font-style":"","title-text-transform":"uppercase","caption-size":"16px","caption-font-style":"","read-more-size":"14px","title-left-icon-color":"","title-color":"","caption-color":"","read-more-color":"","read-more-divider-color":"","title-wrap-bottom-margin":"","title-carousel-nav-style":"default"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"View All Cases","link-to":"custom-url","custom-image":"","video-url":"","button-link":"/financity/demo3/portfolio-3-columns/","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","text-align":"center","full-width-button":"disable","button-padding":{"top":"17px","right":"38px","bottom":"23px","left":"38px","settings":"unlink"},"border-radius":"33px","button-background":"solid","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text-color":"#ffffff","text-hover-color":"","background-color":"#2d5fde","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text2-color":"","text2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","text-size":"15px","text-transform":"none","icon-size":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"#1c42a0","background-image":"5306","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"0.11","pattern-opacity":"1","parallax-speed":"0.1","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"90px","right":"0px","bottom":"60px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"fadeInLeft","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"5553","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"5539","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"round","border-radius":"4px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"fadeInRight","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"20px","right":"0px","bottom":"0px","left":"35px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Something About Us","caption":"Our Little Story","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"45px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"14px","caption-font-weight":"500","caption-font-style":"normal","caption-font-letter-spacing":"2px","caption-font-uppercase":"enable","left-icon-color":"","title-color":"#ffffff","title-link-hover-color":"","caption-color":"#a1bcfe","caption-spaces":"4px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"25px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot, which was created for the bliss of souls like mine. I am so happy, my dear friend, so absorbed in tI tshould be incapable of drawing a single stroke at the present moment; and yet I feel that I never was a greater artist than now. When, while the lovely valley teems with vapour around me, and the meridian.","text-align":"left","apply-the-content-filter":"disable","font-size":"17px","text-color":"#d1defe","padding-bottom":"0px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Learn More","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"right","icon":"fa fa-long-arrow-right","text-align":"left","full-width-button":"disable","button-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"border-radius":"0px","button-background":"transparent","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text-color":"#ffffff","text-hover-color":"","background-color":"","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text2-color":"","text2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","text-size":"16px","text-transform":"none","icon-size":"17px","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"custom","max-width-wrapper":"","max-width":"1360px","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"95px","right":"0px","bottom":"65px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"gallery","value":{"id":"","class":"","gallery":[{"id":"4141","thumbnail":"http://demo.goodlayers.com/financity/wp-content/uploads/2016/11/banner-3.png","link-to":"none","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self"},{"id":"4142","thumbnail":"http://demo.goodlayers.com/financity/wp-content/uploads/2016/11/banner-4.png","link-to":"none","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self"},{"id":"4140","thumbnail":"http://demo.goodlayers.com/financity/wp-content/uploads/2016/11/banner-2.png","link-to":"none","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self"},{"id":"4139","thumbnail":"http://demo.goodlayers.com/financity/wp-content/uploads/2016/11/banner-1.png","link-to":"none","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self"},{"id":"5391","thumbnail":"http://demo.goodlayers.com/financity/wp-content/uploads/2017/06/banner-5-150x43.png","link-to":"none","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self"}],"pagination":"none","show-amount":"20","pagination-style":"default","pagination-align":"default","style":"grid","max-slider-height":"500px","overlay":"none","show-caption":"disable","overlay-on-hover":"disable","column":"5","layout":"carousel","slider-navigation":"navigation","slider-effects":"default","enable-direction-navigation":"disable","thumbnail-navigation":"below-slider","carousel-autoslide":"enable","grid-slider-navigation":"none","thumbnail-size":"full","slider-thumbnail-size":"medium","image-bottom-margin":"","padding-bottom":"30px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"custom","max-width-wrapper":"","max-width":"800px","enable-space":"disable","hide-this-wrapper-in":"none","animation":"fadeIn","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"#262626","background-image":"5474","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"0.09","pattern-opacity":"1","parallax-speed":"0.1","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"120px","right":"0px","bottom":"180px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"HP Testimonial"},"items":[{"template":"element","type":"testimonial","value":{"id":"","class":"","title":"Clients\' Testimonials","title-left-icon":"","caption":"","tabs":[{"title":"John Smith","position":"CEO, Press Mag","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place and supplies it with the necessary.","image":"","image-img":"","rating":""},{"title":"Jane Doe","position":"Jounalist","content":"One morning, when Gregor Samsa woke from troubled dreams, he found himself transformed in his bed into a horrible vermin. He lay on his armour-like back, and if he lifted his head a little he could see his brown belly, slightly domed and divided by arches into stiff sections. The bedding was hardly.","image":"","image-img":"","rating":""}],"style":"center","column":"1","enable-quote":"enable","carousel":"enable","carousel-autoslide":"disable","carousel-navigation":"bullet","carousel-nav-style":"default","title-size":"42px","title-text-transform":"none","title-font-weight":"600","title-letter-spacing":"0px","caption-size":"16px","content-size":"21px","title-color":"#ffffff","caption-color":"","quote-color":"#ffffff","content-color":"#cacaca","name-color":"#ffffff","position-color":"#cacaca","title-wrap-bottom-margin":"30px","content-bottom-padding":"0px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"full","max-width-wrapper":"1240px","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"#ffffff","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":{"x":"","y":"","size":"73px","settings":"unlink"},"background-shadow-color":"#0a0a0a","background-shadow-opacity":"0.07","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"-120px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"quote-height","centering-sync-height-content":"disable","background-type":"image","background-extending":"none","background-color":"","background-image":"5499","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""}},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"quote-height","centering-sync-height-content":"enable","background-type":"color","background-extending":"none","background-color":"#ffffff","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"70px","right":"60px","bottom":"60px","left":"75px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"blockquote","value":{"id":"","class":"","content":"Our goal is to be at the heart of the financial services industry as businesses expand across.","author":"John Smith","author-position":"CEO Of Financity","text-align":"left","size":"large","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"5502","background-image-style":"no-repeat","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.04","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"110px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Latest News","caption":"","caption-position":"bottom","title-width":"300px","title-link-text":"Read All News","title-link":"/financity/demo3/blog-full-right-sidebar-with-frame/","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"44px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"14px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"2px","caption-font-uppercase":"enable","left-icon-color":"","title-color":"#272727","title-link-hover-color":"","caption-color":"","caption-spaces":"5px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"55px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"fadeInUp","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"Hp3 Stats"},"items":[{"template":"element","type":"blog","value":{"id":"","class":"","category":"","tag":"","num-fetch":"5","prepend-sticky":"disable","orderby":"date","order":"desc","filterer":"none","filterer-align":"center","pagination":"none","pagination-style":"default","pagination-align":"default","offset":"0","blog-style":"blog-column-with-frame","blog-full-alignment":"left","blog-list-with-frame":"disable","always-show-overlay-content":"disable","show-thumbnail":"enable","thumbnail-size":"full","enable-thumbnail-opacity-on-hover":"enable","enable-thumbnail-zoom-on-hover":"enable","enable-thumbnail-grayscale-effect":"disable","column-size":"20","layout":"carousel","carousel-autoslide":"enable","carousel-navigation":"bullet","item-size":"small","excerpt":"specify-number","excerpt-number":"21","blog-date-feature":"enable","meta-option":["date","author","category"],"show-read-more":"enable","filterer-bottom-margin":"","blog-title-font-size":"21px","blog-title-font-weight":"600","blog-title-letter-spacing":"0px","blog-title-text-transform":"none","frame-shadow-size":{"x":"","y":"","size":"30px","settings":"unlink"},"frame-shadow-color":"#0a0a0a","frame-shadow-opacity":"0.09","padding-bottom":"60px","title-align":"left","title-left-media":"icon","title-left-icon":"","title-left-image":"","title":"","caption":"","caption-position":"top","read-more-text":"Read More","read-more-link":"","read-more-target":"_self","title-size":"41px","title-letter-spacing":"","title-font-style":"","title-text-transform":"uppercase","caption-size":"16px","caption-font-style":"","read-more-size":"14px","title-left-icon-color":"","title-color":"","caption-color":"","read-more-color":"","read-more-divider-color":"","title-wrap-bottom-margin":"","title-carousel-nav-style":"default"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"#f4f4f4","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"90px","right":"0px","bottom":"60px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"Contact Form White"},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"height-contact","centering-sync-height-content":"enable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Request a call back?","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"40px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"#2d5fde","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"20px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","icon-size":"15px","divider-size":"3px","divider-width":"60px","padding-bottom":"30px","icon-color":"","divider-color":"#cccccc"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Please fill out the form and press the submit button.<br />\nWe will get back to you with 1-2 business days.</p>\n","text-align":"center","apply-the-content-filter":"disable","font-size":"18px","text-color":"","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"height-contact","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"contact-form-7","value":{"id":"","class":"","cf7-id":"5503","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"column","column":"60"}]';
				case 'about1': 
					return '[{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"5417","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.2","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"420px","right":"0px","bottom":"135px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"100px","right":"","bottom":"50px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"About Us","caption":"we provide the solution for asset management","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"93px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"14px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"2px","caption-font-uppercase":"enable","left-icon-color":"","title-color":"#ffffff","title-link-hover-color":"","caption-color":"#e0e0e0","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"85px","right":"0px","bottom":"35px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"5372","title":"Service With Love","caption":"","content":"A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my.","read-more-text":"","read-more-link":"#","style":"center_icon-top","icon-size":"30px","title-size":"19px","title-font-weight":"500","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"14px","content-size":"16px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"","right":"","bottom":"30px","left":""},"title-top-padding":"","title-bottom-margin":"20px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"20","items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"5373","title":"Bring You To The Top","caption":"","content":"A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my.","read-more-text":"","read-more-link":"#","style":"center_icon-top","icon-size":"30px","title-size":"19px","title-font-weight":"500","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"14px","content-size":"16px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"","right":"","bottom":"26px","left":""},"title-top-padding":"","title-bottom-margin":"20px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"20","items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"5374","title":"Great Support","caption":"","content":"A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my.","read-more-text":"","read-more-link":"#","style":"center_icon-top","icon-size":"30px","title-size":"19px","title-font-weight":"500","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"14px","content-size":"16px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"","right":"","bottom":"30px","left":""},"title-top-padding":"","title-bottom-margin":"20px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"20","items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"5375","title":"Go Very Fast","caption":"","content":"A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my.","read-more-text":"","read-more-link":"#","style":"center_icon-top","icon-size":"30px","title-size":"19px","title-font-weight":"500","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"14px","content-size":"16px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"","right":"","bottom":"30px","left":""},"title-top-padding":"","title-bottom-margin":"20px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"20","items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"5376","title":"Business Matching","caption":"","content":"A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my.","read-more-text":"","read-more-link":"#","style":"center_icon-top","icon-size":"30px","title-size":"19px","title-font-weight":"500","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"14px","content-size":"16px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"","right":"","bottom":"32px","left":""},"title-top-padding":"","title-bottom-margin":"20px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"20","items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"5377","title":"Growing Your Business","caption":"","content":"A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my.","read-more-text":"","read-more-link":"#","style":"center_icon-top","icon-size":"30px","title-size":"19px","title-font-weight":"500","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"14px","content-size":"16px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"","right":"","bottom":"30px","left":""},"title-top-padding":"","title-bottom-margin":"20px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"#f6f6f6","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"100px","right":"0px","bottom":"50px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"Grey Text"},"items":[{"template":"wrapper","type":"column","column":"30","items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Read The Story Behind  <br/>Our Success","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"33px","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"30","items":[{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p><span style=\"color: #3c4295;\">We provide buy-side, sell-side and market infrastructure firms</span> with a full-service offering, including systems integration and technology consulting services, to assist in delivering high performance trading and settlement</p>\n<p>More than 25 years of experience working in the industry has enabled us to build our services and solutions in strategy, consulting, digital, technology and operations that help our clients with their trading projects around the world. Capabilities we leverage.</p>\n","text-align":"left","apply-the-content-filter":"disable","font-size":"18px","text-color":"","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"5379","background-image-style":"no-repeat","background-image-position":"top-center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"90px","right":"0px","bottom":"10px","left":"0px","settings":"unlink"},"margin":{"top":"30px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Our Team","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"46px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"personnel","value":{"id":"","class":"","category":"","num-fetch":"5","orderby":"date","order":"desc","text-align":"left","personnel-style":"grid-with-background","enable-position":"enable","disable-link":"disable","enable-divider":"disable","enable-excerpt":"enable","enable-social-shortcode":"disable","column-size":"3","thumbnail-size":"Portfolio Thumbnail Portrait","enable-thumbnail-opacity-on-hover":"enable","enable-thumbnail-zoom-on-hover":"enable","enable-thumbnail-grayscale-effect":"disable","carousel":"enable","carousel-autoslide":"disable","carousel-navigation":"bullet","personnel-title-font-size":"21px","personnel-title-font-weight":"600","personnel-title-letter-spacing":"0px","personnel-title-text-transform":"none","personnel-position-font-size":"16px","personnel-position-font-weight":"400","personnel-position-font-style":"normal","personnel-position-letter-spacing":"0px","personnel-position-text-transform":"none","shadow-size":{"x":"0px","y":"0px","size":"74px","settings":"unlink"},"shadow-color":"#1c1c1c","shadow-opacity":"0.07","personnel-thumbnail-bottom-margin":"35px","personnel-title-bottom-margin":"","padding-bottom":"25px","title-align":"left","title-left-media":"icon","title-left-icon":"","title-left-image":"","title":"","caption":"","caption-position":"top","read-more-text":"Read More","read-more-link":"","read-more-target":"_self","title-size":"41px","title-letter-spacing":"","title-font-style":"","title-text-transform":"uppercase","caption-size":"16px","caption-font-style":"","read-more-size":"14px","title-left-icon-color":"","title-color":"","caption-color":"","read-more-color":"","read-more-divider-color":"","title-wrap-bottom-margin":"","title-carousel-nav-style":"default"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"55px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"Purple Personnel"},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"half-height","centering-sync-height-content":"disable","background-type":"image","background-extending":"left","background-color":"","background-image":"4597","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.2","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""}},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"half-height","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"85px","right":"0px","bottom":"25px","left":"60px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"5381","title":"On Time Service.","caption":"","content":"Transforming distribution and marketing with key capabilities in customer insight and analytics, omni-chan","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"30px","title-size":"22px","title-font-weight":"600","title-letter-spacing":"","title-text-transform":"none","caption-size":"14px","content-size":"16px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"10px","right":"30px","bottom":"","left":""},"title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}},{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"5382","title":"A Team Of Professionals.","caption":"","content":"Transforming distribution and marketing with key capabilities in customer insight and analytics, omni-chan","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"30px","title-size":"22px","title-font-weight":"600","title-letter-spacing":"","title-text-transform":"none","caption-size":"14px","content-size":"16px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"10px","right":"30px","bottom":"","left":""},"title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}},{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"5383","title":"Analyze Your Business.","caption":"","content":"Transforming distribution and marketing with key capabilities in customer insight and analytics, omni-chan","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"30px","title-size":"22px","title-font-weight":"600","title-letter-spacing":"","title-text-transform":"none","caption-size":"14px","content-size":"16px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"10px","right":"30px","bottom":"","left":""},"title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"#f0f0f0","background-image":"5389","background-image-style":"no-repeat","background-image-position":"top-center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"140px","right":"0px","bottom":"120px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"100px","right":"","bottom":"30px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Our Success Stories","caption":"what we have done","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"43px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"14px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"2px","caption-font-uppercase":"enable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"5px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"67px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width-wrapper":"1280px","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"#ffffff","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":{"x":"","y":"","size":"74px","settings":"unlink"},"background-shadow-color":"#141414","background-shadow-opacity":"0.07","padding":{"top":"85px","right":"0px","bottom":"45px","left":"0px","settings":"unlink"},"margin":{"top":"-120px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"0px","right":"","bottom":"","left":"","settings":"unlink"},"skin":"Purple Service"},"items":[{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"15px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"0","end-number":"10000","animation-time":"2000","suffix":"","divider":"disable","bottom-text":"All Time Clients","top-icon-size":"30px","top-text-size":"16px","number-size":"40px","bottom-text-size":"18px","bottom-text-transform":"none","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"0","end-number":"979","animation-time":"2000","suffix":"","divider":"disable","bottom-text":"Clients In This Year","top-icon-size":"30px","top-text-size":"16px","number-size":"40px","bottom-text-size":"18px","bottom-text-transform":"none","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"0","end-number":"300","animation-time":"2000","suffix":"","divider":"disable","bottom-text":"New Projects","top-icon-size":"30px","top-text-size":"16px","number-size":"40px","bottom-text-size":"18px","bottom-text-transform":"none","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"15px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"0","end-number":"35","animation-time":"2000","suffix":"%","divider":"disable","bottom-text":"Avg Profit Increased","top-icon-size":"30px","top-text-size":"16px","number-size":"40px","bottom-text-size":"18px","bottom-text-transform":"none","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"#313787","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"Purple Personnel"},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"half-height-2","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"105px","right":"0px","bottom":"40px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"We are an expert in <br/>this field","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"42px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"#ffffff","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"30px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"17px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Yet I feel that I never was a greater artist than now.<br />\nWhen, while the lovely valley teems.</p>\n","text-align":"left","apply-the-content-filter":"disable","font-size":"19px","text-color":"#93ecf9","padding-bottom":"10px"}},{"template":"element","type":"icon-list","value":{"id":"","class":"","tabs":[{"icon":"icon_check","icon-hover":"","title":"Premium services and beyond your expectation","link-url":""},{"icon":"icon_check","icon-hover":"","title":"Get the best support among all venders","link-url":""},{"icon":"icon_check","icon-hover":"","title":"Fully responsive and works great on all major devices","link-url":""},{"icon":"icon_check","icon-hover":"","title":"Tons of admin panel options","link-url":""}],"columns":"60","enable-divider":"disable","icon-background":"none","icon-color":"#ffffff","icon-background-color":"","content-color":"#a4abfb","border-color":"","icon-size":"16px","content-size":"16px","list-bottom-margin":"8px","padding-bottom":"40px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"half-height-2","centering-sync-height-content":"disable","background-type":"image","background-extending":"right","background-color":"","background-image":"5390","background-image-style":"cover","background-image-position":"top-right","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.2","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width-wrapper":"1280px","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"#ffffff","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":{"x":"","y":"","size":"74px","settings":"unlink"},"background-shadow-color":"#141414","background-shadow-opacity":"0.1","padding":{"top":"70px","right":"10px","bottom":"10px","left":"10px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"70px","left":"0px","settings":"unlink"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"0px","right":"","bottom":"","left":"","settings":"unlink"},"skin":"Purple Service"},"items":[{"template":"element","type":"gallery","value":{"id":"","class":"","gallery":[{"id":"4141","thumbnail":"http://demo.goodlayers.com/financity/wp-content/uploads/2016/11/banner-3.png","link-to":"none","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self"},{"id":"4142","thumbnail":"http://demo.goodlayers.com/financity/wp-content/uploads/2016/11/banner-4.png","link-to":"none","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self"},{"id":"4140","thumbnail":"http://demo.goodlayers.com/financity/wp-content/uploads/2016/11/banner-2.png","link-to":"none","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self"},{"id":"4139","thumbnail":"http://demo.goodlayers.com/financity/wp-content/uploads/2016/11/banner-1.png","link-to":"none","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self"},{"id":"5391","thumbnail":"http://demo.goodlayers.com/financity/wp-content/uploads/2017/06/banner-5-150x43.png","link-to":"none","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self"}],"pagination":"none","show-amount":"20","pagination-style":"default","pagination-align":"default","style":"grid","max-slider-height":"500px","overlay":"none","show-caption":"disable","overlay-on-hover":"disable","column":"5","layout":"carousel","slider-navigation":"navigation","slider-effects":"default","enable-direction-navigation":"disable","thumbnail-navigation":"below-slider","carousel-autoslide":"enable","grid-slider-navigation":"none","thumbnail-size":"full","slider-thumbnail-size":"medium","image-bottom-margin":"","padding-bottom":"60px"}}]}]';
				case 'about2': 
					return '[{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"5238","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.2","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"420px","right":"0px","bottom":"135px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"100px","right":"","bottom":"50px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"About Us","caption":"we provide the solution for asset management","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"93px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"14px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"2px","caption-font-uppercase":"enable","left-icon-color":"","title-color":"#ffffff","title-link-hover-color":"","caption-color":"#e0e0e0","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"#f6f6f6","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"100px","right":"0px","bottom":"170px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"60px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"Grey Text"},"items":[{"template":"wrapper","type":"column","column":"30","items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Read The Story Behind  <br/>Our Success","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"33px","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"left","icon-size":"15px","divider-size":"3px","divider-width":"109px","padding-bottom":"30px","icon-color":"","divider-color":"#313787"}}]},{"template":"wrapper","type":"column","column":"30","items":[{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p><span style=\"color: #3c4295;\">We provide buy-side, sell-side and market infrastructure firms</span> with a full-service offering, including systems integration and technology consulting services, to assist in delivering high performance trading and settlement</p>\n<p>More than 25 years of experience working in the industry has enabled us to build our services and solutions in strategy, consulting, digital, technology and operations that help our clients with their trading projects around the world. Capabilities we leverage.</p>\n","text-align":"left","font-size":"19px","text-color":"","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width-wrapper":"1280px","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"#ffffff","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":{"x":"","y":"","size":"74px","settings":"unlink"},"background-shadow-color":"#141414","background-shadow-opacity":"0.07","padding":{"top":"85px","right":"0px","bottom":"45px","left":"0px","settings":"unlink"},"margin":{"top":"-120px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"0px","right":"","bottom":"","left":"","settings":"unlink"},"skin":"Purple Service"},"items":[{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"15px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"0","end-number":"10000","animation-time":"2000","suffix":"","divider":"disable","bottom-text":"All Time Clients","top-icon-size":"30px","top-text-size":"16px","number-size":"40px","bottom-text-size":"18px","bottom-text-transform":"none","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"0","end-number":"979","animation-time":"2000","suffix":"","divider":"disable","bottom-text":"Clients In This Year","top-icon-size":"30px","top-text-size":"16px","number-size":"40px","bottom-text-size":"18px","bottom-text-transform":"none","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"0","end-number":"300","animation-time":"2000","suffix":"","divider":"disable","bottom-text":"New Projects","top-icon-size":"30px","top-text-size":"16px","number-size":"40px","bottom-text-size":"18px","bottom-text-transform":"none","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"15px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"0","end-number":"35","animation-time":"2000","suffix":"%","divider":"disable","bottom-text":"Avg Profit Increased","top-icon-size":"30px","top-text-size":"16px","number-size":"40px","bottom-text-size":"18px","bottom-text-transform":"none","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"5403","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.2","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"140px","right":"0px","bottom":"80px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"Column Service White"},"items":[{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"5404","title":"On Time  <br/>Service.","caption":"","content":"Transforming distribution and marketing with key capabilities in customer insight and analytics, omni-chan","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"30px","title-size":"22px","title-font-weight":"600","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"14px","content-size":"17px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"10px","right":"30px","bottom":"","left":""},"title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"5405","title":"A Team Of  <br/>Professionals.","caption":"","content":"Transforming distribution and marketing with key capabilities in customer insight and analytics, omni-chan","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"30px","title-size":"22px","title-font-weight":"600","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"14px","content-size":"17px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"10px","right":"30px","bottom":"","left":""},"title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"5406","title":"Analyze Your  <br/>Business.","caption":"","content":"Transforming distribution and marketing with key capabilities in customer insight and analytics, omni-chan","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"30px","title-size":"22px","title-font-weight":"600","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"14px","content-size":"17px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"10px","right":"30px","bottom":"","left":""},"title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"#1d1d1d","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"Purple Personnel"},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"half-height","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"110px","right":"40px","bottom":"55px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"We have more than <br/>ten years of experience ","caption":"WHY US ?","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"42px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"2px","caption-font-uppercase":"enable","left-icon-color":"","title-color":"#ffffff","title-link-hover-color":"","caption-color":"#ffffff","caption-spaces":"10px","media-margin":{"top":"30px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"40px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot, which was created for the bliss of souls like mine. More than 25 years of experience working in the industry has enabled us to build our services and solutions in strategy, consulting, digital.","text-align":"left","apply-the-content-filter":"disable","font-size":"18px","text-color":"#c1c1c1","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"half-height","centering-sync-height-content":"disable","background-type":"image","background-extending":"right","background-color":"","background-image":"5402","background-image-style":"cover","background-image-position":"center-right","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.2","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"#313787","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"Purple Personnel"},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"half-height-2","centering-sync-height-content":"disable","background-type":"image","background-extending":"left","background-color":"","background-image":"5395","background-image-style":"cover","background-image-position":"top-right","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.2","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""}},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"half-height-2","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"110px","right":"0px","bottom":"55px","left":"70px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"We have more than <br/>ten years of experience ","caption":"WHY US ?","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"42px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"2px","caption-font-uppercase":"enable","left-icon-color":"","title-color":"#ffffff","title-link-hover-color":"","caption-color":"#ffffff","caption-spaces":"10px","media-margin":{"top":"30px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"40px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot, which was created for the bliss of souls like mine. More than 25 years of experience working in the industry has enabled us to build our services and solutions in strategy.","text-align":"left","apply-the-content-filter":"disable","font-size":"18px","text-color":"#b4b7ec","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"custom","max-width-wrapper":"","max-width":"840px","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"90px","right":"0px","bottom":"60px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"testimonial","value":{"id":"","class":"","title":"Clients\' Testimonials","title-left-icon":"","caption":"","tabs":[{"title":"John Smith","position":"CEO, Press Mag","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place and supplies it with the necessary.","image":"","image-img":"","rating":""},{"title":"Jane Doe","position":"Manager, Coke","content":"One morning, when Gregor Samsa woke from troubled dreams, he found himself transformed in his bed into a horrible vermin. He lay on his armour-like back, and if he lifted his head a little he could see his brown belly, slightly domed and divided by arches into stiff sections. The bedding.","image":"","image-img":"","rating":""}],"style":"center","column":"1","enable-quote":"enable","carousel":"enable","carousel-autoslide":"enable","carousel-navigation":"navigation","carousel-nav-style":"default","title-size":"30px","title-text-transform":"none","title-font-weight":"400","title-letter-spacing":"0px","caption-size":"16px","content-size":"20px","title-color":"","caption-color":"","quote-color":"","content-color":"","name-color":"","position-color":"","title-wrap-bottom-margin":"40px","content-bottom-padding":"0px","padding-bottom":"30px"}}]}]';
				case 'about3': 
					return '[{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"5238","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.2","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"420px","right":"0px","bottom":"135px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"100px","right":"","bottom":"50px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"About Us","caption":"we provide the solution for asset management","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"93px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"14px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"2px","caption-font-uppercase":"enable","left-icon-color":"","title-color":"#ffffff","title-link-hover-color":"","caption-color":"#e0e0e0","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"85px","right":"0px","bottom":"35px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"5372","title":"Service With Love","caption":"","content":"A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my.","read-more-text":"","read-more-link":"#","style":"center_icon-top","icon-size":"30px","title-size":"19px","title-font-weight":"500","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"14px","content-size":"16px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"","right":"","bottom":"30px","left":""},"title-top-padding":"","title-bottom-margin":"20px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"20","items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"5373","title":"Bring You To The Top","caption":"","content":"A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my.","read-more-text":"","read-more-link":"#","style":"center_icon-top","icon-size":"30px","title-size":"19px","title-font-weight":"500","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"14px","content-size":"16px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"","right":"","bottom":"26px","left":""},"title-top-padding":"","title-bottom-margin":"20px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"20","items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"5374","title":"Great Support","caption":"","content":"A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my.","read-more-text":"","read-more-link":"#","style":"center_icon-top","icon-size":"30px","title-size":"19px","title-font-weight":"500","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"14px","content-size":"16px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"","right":"","bottom":"30px","left":""},"title-top-padding":"","title-bottom-margin":"20px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"5409","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.1","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"120px","right":"0px","bottom":"70px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Read The Story Behind  Our Success","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"36px","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"#ffffff","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>We provide buy-side, sell-side and market infrastructure firms with a full-service offering, including systems integration and technology consulting services, to assist in delivering high performance trading and settlement</p>\n<p>More than 25 years of experience working in the industry has enabled us to build our services and solutions in strategy, consulting, digital, technology and operations that help our clients with their trading projects around the world.</p>\n","text-align":"left","apply-the-content-filter":"disable","font-size":"19px","text-color":"#d4d7ff","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"125px","right":"0px","bottom":"0px","left":"30px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"skill-bar","value":{"id":"","class":"","bar-size":"small","bar-type":"round","tabs":[{"heading-text":"Financing","icon":"","percent":"85","bar-text":""},{"heading-text":"Stock Trading","icon":"","percent":"100","bar-text":""},{"heading-text":"Tax Planning","icon":"","percent":"90","bar-text":""},{"heading-text":"Accouting Advisory","icon":"","percent":"97","bar-text":""}],"heading-text-color":"#ffffff","icon-color":"","percent-color":"#ffffff","bar-filled-color":"#ffffff","bar-background-color":"#5f64a3","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"95px","right":"0px","bottom":"50px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"20","items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Why Choose Us?","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"27px","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"40","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"Purple Service"},"items":[{"template":"element","type":"accordion","value":{"id":"","class":"","tabs":[{"head-text":"","title":"Business Information","content":"Our Trading helps clients run and transform their front, middle and back-office trading operations. We provide buy-side, sell-side and market infrastructure firms with a full-service offering, including systems integration and technology consulting services, to assist in delivering high performance trading and settlement capabilities across all asset classes. This includes strategy, architecture design, operating model work, proce ss improvement, systems building and trading."},{"head-text":"","title":"Key Analyze","content":"Our Trading helps clients run and transform their front, middle and back-office trading operations. We provide buy-side, sell-side and market infrastructure firms with a full-service offering, including systems integration and technology consulting services, to assist in delivering high performance trading and settlement capabilities across all asset classes. This includes strategy, architecture design, operating model work, proce ss improvement, systems building and trading."},{"head-text":"","title":"Our Workflow & Process","content":"Our Trading helps clients run and transform their front, middle and back-office trading operations. We provide buy-side, sell-side and market infrastructure firms with a full-service offering, including systems integration and technology consulting services, to assist in delivering high performance trading and settlement capabilities across all asset classes. This includes strategy, architecture design, operating model work, proce ss improvement, systems building and trading."}],"active":"1","allow-closing-all-tabs":"disable","style":"box-icon","align":"left","padding-bottom":"35px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Our Trading helps clients run and transform their front, middle and back-office trading operations. We provide buy-side, sell-side and market infrastructure firms with a full-service offering, including systems integration and technology consulting services, to assist in delivering high performance trading and settlement capabilities across all asset classes. This includes strategy, architecture design.","text-align":"left","apply-the-content-filter":"disable","font-size":"19px","text-color":"","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"custom","max-width-wrapper":"","max-width":"1050px","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"5410","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.2","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"160px","right":"0px","bottom":"100px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Read The Story Behind Our Success","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"32px","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"#ffffff","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"We provide buy-side, sell-side and market infrastructure firms with a full-service offering, including systems integration and technology consulting services, to assist in delivering high performance trading and settlement","text-align":"center","apply-the-content-filter":"disable","font-size":"19px","text-color":"#d4d7ff","padding-bottom":"30px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"#f6f6f6","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"100px","right":"0px","bottom":"60px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"Grey Text"},"items":[{"template":"wrapper","type":"column","column":"20","items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Award Winning","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"27px","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"20","items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"The Best Of Financial Corp","caption":"Forbes Mag, 2014","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"18px","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"15px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"#313787","title-link-hover-color":"","caption-color":"#424242","caption-spaces":"6px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"32px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Silver Price, Highest Return Portfolio","caption":"Morningstar Award, 2016","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"18px","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"15px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"#313787","title-link-hover-color":"","caption-color":"#424242","caption-spaces":"6px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"32px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"The Best Of Financial Corp","caption":"Forbes Mag, 2014","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"18px","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"15px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"#313787","title-link-hover-color":"","caption-color":"#424242","caption-spaces":"6px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"32px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Silver Price, Highest Return Portfolio","caption":"Morningstar Award, 2016","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"18px","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"15px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"#313787","title-link-hover-color":"","caption-color":"#424242","caption-spaces":"6px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"32px"}}]},{"template":"wrapper","type":"column","column":"20","items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Fintech Rookie","caption":"Technologo Mag, 2015","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"18px","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"15px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"#313787","title-link-hover-color":"","caption-color":"#424242","caption-spaces":"6px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"32px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Best Consult Company","caption":"London Fund Associate, 2016","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"18px","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"15px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"#313787","title-link-hover-color":"","caption-color":"#424242","caption-spaces":"6px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"32px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Fintech Rookie","caption":"Technologo Mag, 2015","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"18px","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"15px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"#313787","title-link-hover-color":"","caption-color":"#424242","caption-spaces":"6px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"32px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Best Consult Company","caption":"London Fund Associate, 2016","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"18px","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"15px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"#313787","title-link-hover-color":"","caption-color":"#424242","caption-spaces":"6px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"32px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"#ffffff","background-image":"5411","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.2","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":{"x":"","y":"","size":"74px","settings":"unlink"},"background-shadow-color":"#141414","background-shadow-opacity":"0.07","padding":{"top":"95px","right":"0px","bottom":"55px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"0px","right":"","bottom":"","left":"","settings":"unlink"},"skin":"Dark"},"items":[{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"15px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"0","end-number":"10000","animation-time":"2000","suffix":"","divider":"disable","bottom-text":"All Time Clients","top-icon-size":"30px","top-text-size":"16px","number-size":"40px","bottom-text-size":"18px","bottom-text-transform":"none","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"0","end-number":"979","animation-time":"2000","suffix":"","divider":"disable","bottom-text":"Clients In This Year","top-icon-size":"30px","top-text-size":"16px","number-size":"40px","bottom-text-size":"18px","bottom-text-transform":"none","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"0","end-number":"300","animation-time":"2000","suffix":"","divider":"disable","bottom-text":"New Projects","top-icon-size":"30px","top-text-size":"16px","number-size":"40px","bottom-text-size":"18px","bottom-text-transform":"none","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"15px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"0","end-number":"35","animation-time":"2000","suffix":"%","divider":"disable","bottom-text":"Avg Profit Increased","top-icon-size":"30px","top-text-size":"16px","number-size":"40px","bottom-text-size":"18px","bottom-text-transform":"none","padding-bottom":"30px"}}]}]}]';
				case 'about-our-team': 
					return '[{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"5417","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.1","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"420px","right":"0px","bottom":"135px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"100px","right":"","bottom":"50px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"About Us","caption":"we provide the solution for asset management","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"93px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"14px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"2px","caption-font-uppercase":"enable","left-icon-color":"","title-color":"#ffffff","title-link-hover-color":"","caption-color":"#e0e0e0","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"5379","background-image-style":"no-repeat","background-image-position":"top-center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.03","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"50px","right":"0px","bottom":"10px","left":"0px","settings":"unlink"},"margin":{"top":"30px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Introduce","caption":"The Best Team","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"46px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"14px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"2px","caption-font-uppercase":"enable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"5px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"80px"}},{"template":"element","type":"personnel","value":{"id":"","class":"","category":"","num-fetch":"6","orderby":"date","order":"desc","text-align":"left","personnel-style":"grid-with-background","enable-position":"enable","disable-link":"disable","enable-divider":"disable","enable-excerpt":"enable","enable-social-shortcode":"disable","column-size":"3","thumbnail-size":"Portfolio Thumbnail Portrait","enable-thumbnail-opacity-on-hover":"enable","enable-thumbnail-zoom-on-hover":"enable","enable-thumbnail-grayscale-effect":"disable","carousel":"disable","carousel-autoslide":"disable","carousel-navigation":"bullet","personnel-title-font-size":"21px","personnel-title-font-weight":"600","personnel-title-letter-spacing":"0px","personnel-title-text-transform":"none","personnel-position-font-size":"15px","personnel-position-font-weight":"400","personnel-position-font-style":"normal","personnel-position-letter-spacing":"0px","personnel-position-text-transform":"none","shadow-size":{"x":"0px","y":"0px","size":"74px","settings":"unlink"},"shadow-color":"#1c1c1c","shadow-opacity":"0.07","personnel-thumbnail-bottom-margin":"35px","personnel-title-bottom-margin":"","padding-bottom":"25px","title-align":"left","title-left-media":"icon","title-left-icon":"","title-left-image":"","title":"","caption":"","caption-position":"top","read-more-text":"Read More","read-more-link":"","read-more-target":"_self","title-size":"41px","title-letter-spacing":"","title-font-style":"","title-text-transform":"uppercase","caption-size":"16px","caption-font-style":"","read-more-size":"14px","title-left-icon-color":"","title-color":"","caption-color":"","read-more-color":"","read-more-divider-color":"","title-wrap-bottom-margin":"","title-carousel-nav-style":"default"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"25px","right":"0px","bottom":"35px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"20","items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"5375","title":"Go Very Fast","caption":"","content":"A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my.","read-more-text":"","read-more-link":"#","style":"center_icon-top","icon-size":"30px","title-size":"19px","title-font-weight":"500","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"14px","content-size":"16px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"","right":"","bottom":"30px","left":""},"title-top-padding":"","title-bottom-margin":"20px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"20","items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"5376","title":"Business Matching","caption":"","content":"A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my.","read-more-text":"","read-more-link":"#","style":"center_icon-top","icon-size":"30px","title-size":"19px","title-font-weight":"500","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"14px","content-size":"16px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"","right":"","bottom":"32px","left":""},"title-top-padding":"","title-bottom-margin":"20px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"20","items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"5377","title":"Growing Your Business","caption":"","content":"A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my.","read-more-text":"","read-more-link":"#","style":"center_icon-top","icon-size":"30px","title-size":"19px","title-font-weight":"500","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"14px","content-size":"16px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"","right":"","bottom":"30px","left":""},"title-top-padding":"","title-bottom-margin":"20px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"#f0f0f0","background-image":"5389","background-image-style":"no-repeat","background-image-position":"top-center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.1","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"110px","right":"0px","bottom":"250px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"100px","right":"","bottom":"30px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Our Success Stories","caption":"what we have done","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"43px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"14px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"2px","caption-font-uppercase":"enable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"5px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"67px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width-wrapper":"1280px","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"#ffffff","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":{"x":"","y":"","size":"74px","settings":"unlink"},"background-shadow-color":"#141414","background-shadow-opacity":"0.07","padding":{"top":"85px","right":"0px","bottom":"45px","left":"0px","settings":"unlink"},"margin":{"top":"-250px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"0px","right":"","bottom":"","left":"","settings":"unlink"},"skin":"Purple Service"},"items":[{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"15px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"0","end-number":"10000","animation-time":"2000","suffix":"","divider":"disable","bottom-text":"All Time Clients","top-icon-size":"30px","top-text-size":"16px","number-size":"40px","bottom-text-size":"18px","bottom-text-transform":"none","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"0","end-number":"979","animation-time":"2000","suffix":"","divider":"disable","bottom-text":"Clients In This Year","top-icon-size":"30px","top-text-size":"16px","number-size":"40px","bottom-text-size":"18px","bottom-text-transform":"none","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"0","end-number":"300","animation-time":"2000","suffix":"","divider":"disable","bottom-text":"New Projects","top-icon-size":"30px","top-text-size":"16px","number-size":"40px","bottom-text-size":"18px","bottom-text-transform":"none","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"15px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"0","end-number":"35","animation-time":"2000","suffix":"%","divider":"disable","bottom-text":"Avg Profit Increased","top-icon-size":"30px","top-text-size":"16px","number-size":"40px","bottom-text-size":"18px","bottom-text-transform":"none","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"5410","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.2","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"120px","right":"0px","bottom":"46px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"45","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"40px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Looking For A Job?","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"32px","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"#ffffff","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"27px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"We provide buy-side, sell-side and market infrastructure firms with a full-service offering, including systems integration and technology consulting services, to assist in delivering high performance trading and settlement","text-align":"left","apply-the-content-filter":"disable","font-size":"19px","text-color":"#d4d7ff","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"70px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"0px","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"button","value":{"id":"","class":"","button-text":"He Are Hiring","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","text-align":"center","full-width-button":"disable","button-padding":{"top":"17px","right":"33px","bottom":"17px","left":"33px","settings":"unlink"},"border-radius":"29px","button-background":"solid","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text-color":"#263967","text-hover-color":"#263967","background-color":"#ffffff","background-hover-color":"#dcdff7","background-gradient-color":"","border-color":"","border-hover-color":"","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text2-color":"","text2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","text-size":"14px","text-transform":"","icon-size":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"30px"}}]}]}]';
				case 'career': 
					return '[{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"#111b47","background-image":"5361","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"0.7","pattern-opacity":"1","parallax-speed":"0","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"620px","right":"0px","bottom":"50px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"100px","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Work With The Best","caption":"And learn a lot of new things","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"71px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"14px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"2px","caption-font-uppercase":"enable","left-icon-color":"","title-color":"#ffffff","title-link-hover-color":"","caption-color":"#e0e0e0","caption-spaces":"0px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"5360","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.1","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"130px","right":"0px","bottom":"65px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"20","items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"The Great Opportunities","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"27px","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"#ffffff","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"40","items":[{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Managing a system this complex requires a passion for technology. In offices from Bangkok to New York and dozens of places in between, our talented people work hard every day to find solutions, create value, and push boundaries.","text-align":"left","apply-the-content-filter":"disable","font-size":"19px","text-color":"#d6d6d6","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"90px","right":"0px","bottom":"40px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"20","items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Finance Back Office  Supervisor","caption":"Posted on : July 30, 2017","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"30px","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"#313787","title-link-hover-color":"","caption-color":"#8e8e8e","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"25px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Submit Resume","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"right","icon":"fa fa-long-arrow-right","text-align":"left","full-width-button":"disable","button-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"border-radius":"25px","button-background":"transparent","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text-color":"#e67929","text-hover-color":"","background-color":"","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text2-color":"","text2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","text-size":"14px","text-transform":"","icon-size":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"40","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"20px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"Purple Service"},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Overview","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"20px","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"#232323","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Learn more about who we are and what we do... Finance BackOffice Team is a part of Finance Operations Unit. BOFF is dedicated to supporting the Vendor Master File of Agoda by screening, controlling, evaluating with providing support to ensure compliance with Finance and Company policy; by mitigating risk; and by promoting the financial health of Agoda.</p><p>BOFF is responsible for oversight of vendor\'s Agoda, including efficient and accurate vendor registration and evaluation processing, fraudulent reporting, coordinate internal/external audit and interact within organization for improving work procedures. Are you interested?</p>","text-align":"left","font-size":"","text-color":"","padding-bottom":"30px"}},{"template":"element","type":"accordion","value":{"id":"","class":"","tabs":[{"head-text":"","title":"Responsibilities","content":"[gdlr_core_icon icon=\"fa fa-dot-circle-o\" size=\"17px\" color=\"#313787\" margin-left=\"\" margin-right=\"7px\" ] Increase operational efficiency within the Business Development department. \n[gdlr_core_icon icon=\"fa fa-dot-circle-o\" size=\"17px\" color=\"#313787\" margin-left=\"\" margin-right=\"7px\" ] Recruit, develop, manage, retain, lead staff to ensure adherence to all targets and KPIs.\n[gdlr_core_icon icon=\"fa fa-dot-circle-o\" size=\"17px\" color=\"#313787\" margin-left=\"\" margin-right=\"7px\" ] Support and optimize agoda business development tools.\n[gdlr_core_icon icon=\"fa fa-dot-circle-o\" size=\"17px\" color=\"#313787\" margin-left=\"\" margin-right=\"7px\" ] Ensure good and pro-active team work with subordinates, colleagues and superiors.\n[gdlr_core_icon icon=\"fa fa-dot-circle-o\" size=\"17px\" color=\"#313787\" margin-left=\"\" margin-right=\"7px\" ] Share and seek out best practices and knowledge."},{"head-text":"","title":"Qualifications","content":"[gdlr_core_icon icon=\"fa fa-dot-circle-o\" size=\"17px\" color=\"#313787\" margin-left=\"\" margin-right=\"7px\" ] Bachelor\'s / Master\'s Degree in Accounting/ Finance or Business Administration\n[gdlr_core_icon icon=\"fa fa-dot-circle-o\" size=\"17px\" color=\"#313787\" margin-left=\"\" margin-right=\"7px\" ] At least 4 years of work experience in audit, finance or consulting position\n[gdlr_core_icon icon=\"fa fa-dot-circle-o\" size=\"17px\" color=\"#313787\" margin-left=\"\" margin-right=\"7px\" ] Audit background is preferable\n[gdlr_core_icon icon=\"fa fa-dot-circle-o\" size=\"17px\" color=\"#313787\" margin-left=\"\" margin-right=\"7px\" ] Positive attitude with willingness to learn new things and get more challenging tasks"}],"active":"1","allow-closing-all-tabs":"disable","style":"box-icon","align":"left","padding-bottom":"30px"}}]}]},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","icon-size":"15px","divider-size":"2px","divider-width":"","padding-bottom":"0px","icon-color":"","divider-color":""}},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"80px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"20","items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Senior Supply Innovation  Manager","caption":"Posted on : July 30, 2017","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"30px","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"#313787","title-link-hover-color":"","caption-color":"#8e8e8e","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"25px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Submit Resume","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"right","icon":"fa fa-long-arrow-right","text-align":"left","full-width-button":"disable","button-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"border-radius":"25px","button-background":"transparent","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text-color":"#e67929","text-hover-color":"","background-color":"","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text2-color":"","text2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","text-size":"14px","text-transform":"","icon-size":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"40","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"20px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"Purple Service"},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Overview","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"20px","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"#232323","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Learn more about who we are and what we do... Finance BackOffice Team is a part of Finance Operations Unit. BOFF is dedicated to supporting the Vendor Master File of Agoda by screening, controlling, evaluating with providing support to ensure compliance with Finance and Company policy; by mitigating risk; and by promoting the financial health of Agoda.</p><p>BOFF is responsible for oversight of vendor\'s Agoda, including efficient and accurate vendor registration and evaluation processing, fraudulent reporting, coordinate internal/external audit and interact within organization for improving work procedures. Are you interested?</p>","text-align":"left","font-size":"","text-color":"","padding-bottom":"30px"}},{"template":"element","type":"accordion","value":{"id":"","class":"","tabs":[{"head-text":"","title":"Responsibilities","content":"[gdlr_core_icon icon=\"fa fa-dot-circle-o\" size=\"17px\" color=\"#313787\" margin-left=\"\" margin-right=\"7px\" ] Increase operational efficiency within the Business Development department. \n[gdlr_core_icon icon=\"fa fa-dot-circle-o\" size=\"17px\" color=\"#313787\" margin-left=\"\" margin-right=\"7px\" ] Recruit, develop, manage, retain, lead staff to ensure adherence to all targets and KPIs.\n[gdlr_core_icon icon=\"fa fa-dot-circle-o\" size=\"17px\" color=\"#313787\" margin-left=\"\" margin-right=\"7px\" ] Support and optimize agoda business development tools.\n[gdlr_core_icon icon=\"fa fa-dot-circle-o\" size=\"17px\" color=\"#313787\" margin-left=\"\" margin-right=\"7px\" ] Ensure good and pro-active team work with subordinates, colleagues and superiors.\n[gdlr_core_icon icon=\"fa fa-dot-circle-o\" size=\"17px\" color=\"#313787\" margin-left=\"\" margin-right=\"7px\" ] Share and seek out best practices and knowledge."},{"head-text":"","title":"Qualifications","content":"[gdlr_core_icon icon=\"fa fa-dot-circle-o\" size=\"17px\" color=\"#313787\" margin-left=\"\" margin-right=\"7px\" ] Bachelor\'s / Master\'s Degree in Accounting/ Finance or Business Administration\n[gdlr_core_icon icon=\"fa fa-dot-circle-o\" size=\"17px\" color=\"#313787\" margin-left=\"\" margin-right=\"7px\" ] At least 4 years of work experience in audit, finance or consulting position\n[gdlr_core_icon icon=\"fa fa-dot-circle-o\" size=\"17px\" color=\"#313787\" margin-left=\"\" margin-right=\"7px\" ] Audit background is preferable\n[gdlr_core_icon icon=\"fa fa-dot-circle-o\" size=\"17px\" color=\"#313787\" margin-left=\"\" margin-right=\"7px\" ] Positive attitude with willingness to learn new things and get more challenging tasks"}],"active":"1","allow-closing-all-tabs":"disable","style":"box-icon","align":"left","padding-bottom":"30px"}}]}]}]';
				case 'single-service': 
					return '[{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"mobile","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"5417","background-image-style":"cover","background-image-position":"top-center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"300px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""}},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"#f5f5f5","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"10px","right":"0px","bottom":"10px","left":"40px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"breadcrumbs"}]},{"template":"wrapper","type":"sidebar","value":{"id":"","class":"","content-layout":"boxed","sidebar":"left","sidebar-left":"services","sidebar-right":"gdlr-core-sidebar-preset","sidebar-width":"15","hide-this-wrapper-in":"none","margin":{"top":"0px","right":"0px","bottom":"0px","left":"41px","settings":"unlink"},"padding":{"top":"60px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"","sidebar-padding":{"top":"60px","right":"25px","bottom":"30px","left":"0px","settings":"unlink"},"sidebar-background-color":"","sidebar-skin":""},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"image","background-extending":"right","background-color":"","background-image":"5439","background-image-style":"no-repeat","background-image-position":"top-left","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"50px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Capital Markets","caption":"GLOBAL STRATEGIES, INSIGHT-DRIVEN TRANSFORMATION","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"60px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"13px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"2px","caption-font-uppercase":"enable","left-icon-color":"","title-color":"#3e4494","title-link-hover-color":"","caption-color":"","caption-spaces":"0px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"60","items":[{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Our Trading helps clients run and transform their front, middle and back-office trading operations. We provide buy-side, sell-side and market infrastructure firms with a full-service offering, including systems integration and technology consulting services, to assist in delivering high performance trading and settlement capabilities across all asset classes. This includes strategy, architecture design, operating model work, process improvement, systems building and trading package integration as well as application management, application outsourcing and business process outsourcing. <a href=\"https://demo.goodlayers.com/financity/wp-content/uploads/2017/09/shutterstock_247037281.jpg\"><img class=\"alignleft wp-image-5310\" src=\"https://demo.goodlayers.com/financity/wp-content/uploads/2017/09/shutterstock_247037281.jpg\" alt=\"\" width=\"400\" height=\"273\" /></a>More than 25 years of experience working in the industry has enabled us to build our services and solutions in strategy, consulting, digital, technology and operations that help our clients with their trading projects around the world. Capabilities we leverage for our clients include a powerful alliance network with leading capital markets software vendors, and programs such as the FinTech Innovation Lab that keep us at the forefront of innovation. Our Trading helps clients run and transform their front, middle and back-office trading operations. We provide buy-side, sell-side and market infrastructure firms with a full-service offering, including systems integration and technology consulting Our Trading helps clients run and transform their front, middle and back-office trading operations. We provide buy-side, sell-side and market infrastructure firms with a full-service offering, including systems integration and technology consulting services, to assist in delivering high performance trading and settlement capabilities across all asset classes. This includes strategy, architecture design, operating model work, process improvement, systems building and trading package.</p>","text-align":"left","apply-the-content-filter":"disable","font-size":"","text-color":"","padding-bottom":"20px"}}]},{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"icon-list","value":{"id":"","class":"","tabs":[{"icon":"fa fa-dot-circle-o","icon-hover":"","title":"Amet Sollicitudin Quam Dolor Mollis","link-url":""},{"icon":"fa fa-dot-circle-o","icon-hover":"","title":"Diipiscing Vestibulum Nullam Venenatis","link-url":""},{"icon":"fa fa-dot-circle-o","icon-hover":"","title":"Diipiscing Vestibulum Nullam Venenatis","link-url":""},{"icon":"fa fa-dot-circle-o","icon-hover":"","title":"Vehicula Vulputate Ligula Mollis","link-url":""}],"columns":"60","enable-divider":"disable","icon-background":"none","icon-color":"#313787","icon-background-color":"","content-color":"","border-color":"","icon-size":"17px","content-size":"16px","list-bottom-margin":"10px","padding-bottom":"10px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"Purple Service"},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"5326","title":"A Team <br/>Of Professionals.","caption":"","content":"Transforming distribution and marketing with key capabilities in customer insight and analytics.","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"30px","title-size":"22px","title-font-weight":"600","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"14px","content-size":"16px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"10px","right":"30px","bottom":"","left":""},"title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"Purple Service"},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"5342","title":"Analyze Your  <br/>Business.","caption":"","content":"Transforming distribution and marketing with key capabilities in customer insight and analytics.","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"30px","title-size":"22px","title-font-weight":"600","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"14px","content-size":"16px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"10px","right":"30px","bottom":"","left":""},"title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"Purple Service"},"items":[{"template":"element","type":"accordion","value":{"id":"","class":"","tabs":[{"head-text":"","title":"Business Information","content":"Our Trading helps clients run and transform their front, middle and back-office trading operations. We provide buy-side, sell-side and market infrastructure firms with a full-service offering, including systems integration and technology consulting services, to assist in delivering high performance trading and settlement capabilities across all asset classes. This includes strategy, architecture design, operating model work, process improvement, systems building and trading p"},{"head-text":"","title":"Key Analyze","content":"Our Trading helps clients run and transform their front, middle and back-office trading operations. We provide buy-side, sell-side and market infrastructure firms with a full-service offering, including systems integration and technology consulting services, to assist in delivering high performance trading and settlement capabilities across all asset classes. This includes strategy, architecture design, operating model work, process improvement, systems building and trading p"},{"head-text":"","title":"Our Workflow & Process","content":"Our Trading helps clients run and transform their front, middle and back-office trading operations. We provide buy-side, sell-side and market infrastructure firms with a full-service offering, including systems integration and technology consulting services, to assist in delivering high performance trading and settlement capabilities across all asset classes. This includes strategy, architecture design, operating model work, process improvement, systems building and trading p"}],"active":"1","allow-closing-all-tabs":"disable","style":"box-icon","align":"left","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"25px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Our Trading helps clients run and transform their front, middle and back-office trading operations. We provide buy-side, sell-side and market infrastructure firms with a full-service offering, including systems integration and technology consulting services, to assist in delivering high performance trading and settlement capabilities across all asset classes. This includes strategy, architecture design, operating model work, process improvement, systems building and trading p</p>","text-align":"left","font-size":"","text-color":"","padding-bottom":"20px"}}]},{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"Purple Service"},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Capital Markets Specialist","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"28px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"#232323","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"40px"}},{"template":"element","type":"personnel","value":{"id":"","class":"","category":"","num-fetch":"2","orderby":"date","order":"desc","text-align":"left","personnel-style":"grid","enable-position":"enable","disable-link":"disable","enable-divider":"enable","enable-excerpt":"enable","enable-social-shortcode":"disable","column-size":"3","thumbnail-size":"Blog Column Thumbnail","enable-thumbnail-opacity-on-hover":"enable","enable-thumbnail-zoom-on-hover":"enable","enable-thumbnail-grayscale-effect":"disable","carousel":"disable","carousel-autoslide":"enable","carousel-navigation":"navigation","personnel-title-font-size":"18px","personnel-title-font-weight":"500","personnel-title-letter-spacing":"0px","personnel-title-text-transform":"none","personnel-position-font-size":"15px","personnel-position-font-weight":"400","personnel-position-font-style":"normal","personnel-position-letter-spacing":"0px","personnel-position-text-transform":"none","shadow-color":"","shadow-opacity":"0.2","personnel-thumbnail-bottom-margin":"","personnel-title-bottom-margin":"4px","padding-bottom":"20px","title-align":"left","title-left-media":"icon","title-left-icon":"","title-left-image":"","title":"","caption":"","caption-position":"top","read-more-text":"Read More","read-more-link":"","read-more-target":"_self","title-size":"41px","title-letter-spacing":"","title-font-style":"","title-text-transform":"uppercase","caption-size":"16px","caption-font-style":"","read-more-size":"14px","title-left-icon-color":"","title-color":"","caption-color":"","read-more-color":"","read-more-divider-color":"","title-wrap-bottom-margin":"","title-carousel-nav-style":"default"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"#313787","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"55px","right":"0px","bottom":"50px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"48","items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Share This","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"right","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"div","icon-font-size":"30px","title-font-size":"18px","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"#ffffff","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"10px"}}]},{"template":"wrapper","type":"column","column":"12","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"social-network","value":{"id":"","class":"","delicious":"","email":"","deviantart":"","digg":"","facebook":"#","flickr":"","google-plus":"#","lastfm":"","linkedin":"","pinterest":"#","rss":"","skype":"#","stumbleupon":"","tumblr":"","twitter":"#","vimeo":"","youtube":"","dribbble":"","behance":"","instagram":"#","snapchat":"","text-align":"left","icon-size":"18px","with-text":"disable","text-size":"18px","icon-color":"#ffffff","icon-space":"20px","padding-bottom":"0px"}}]}]}]';
				case 'single-case1': 
					return '[{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"5238","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.2","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"360px","right":"0px","bottom":"140px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"90px","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Startup Funding","caption":"We provide the solution for asset management","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"68px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"14px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"2px","caption-font-uppercase":"enable","left-icon-color":"","title-color":"#ffffff","title-link-hover-color":"","caption-color":"#efefef","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"90px","right":"0px","bottom":"25px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"-170px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"5324","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"enable","background-shadow-size":{"x":"","y":"","size":"74px","settings":"unlink"},"background-shadow-color":"#0f0f0f","background-shadow-opacity":"0.07","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"40px","left":"30px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Project Title","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h4","icon-font-size":"30px","title-font-size":"27px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Our Trading helps clients run and transform their front, middle and back-office trading operations. We provide buy-side, sell-side and market infrastructure firms with a full-service offering, including systems integration and technology consulting services, to assist in delivering high. Our Trading helps clients run and transform their front, middle and back-office trading operations. We provide buy-side, sell.","text-align":"left","apply-the-content-filter":"disable","font-size":"16px","text-color":"","padding-bottom":"30px"}},{"template":"element","type":"port-info","value":{"id":"","class":"","port-info":[{"key":"Client","value":"DreamAct"},{"key":"Date","value":"17 August 2017"}],"enable-post-type-tax":"disable","enable-bottom-border":"disable","taxonomy-head-text":"Tags","taxonomy":"portfolio_tag","enable-social-share":"disable","social-facebook":"enable","social-linkedin":"enable","social-google-plus":"enable","social-pinterest":"enable","social-stumbleupon":"enable","social-twitter":"enable","social-email":"disable","padding-bottom":"50px"}}]},{"template":"wrapper","type":"column","column":"36","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"50px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"Purple Service"},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Result Driven","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h4","icon-font-size":"30px","title-font-size":"25px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"#2b2b2b","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>More than 25 years of experience working in the industry has enabled us to build our services and solutions in strategy, consulting, digital, technology and operations that help our clients with their trading projects around the world. Capabilities we leverage for our clients include a powerful alliance network with leading capital markets software vendors, and programs such as the FinTech Innovation Lab that keep us at the forefront of innovation. Our Trading helps clients run and transform their front, middle and back-office trading operations. We provide buy-side, sell-side and market infrastructure firms.</p>\n<p><span style=\"font-size: 21px;\">We provide buy-side, sell-side and market infrastructure firms with a full-service offering, including systems integration and technology consulting services, to assist in delivering high performance trading and settlement.</span></p>\n","text-align":"left","apply-the-content-filter":"disable","font-size":"16px","text-color":"","padding-bottom":"30px"}},{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"5326","title":"A Team Of Professionals.","caption":"","content":"Transforming distribution and marketing with key capabilities in customer insight and analytics, omni-chan vide buy-side, sell-side and market infrastructure firms with a full-service offering, including systems.","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"30px","title-size":"22px","title-font-weight":"600","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"14px","content-size":"16px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"10px","right":"25px","bottom":"","left":""},"title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"24","items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"5325","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"enable","background-shadow-size":{"x":"","y":"","size":"74px","settings":"unlink"},"background-shadow-color":"#161616","background-shadow-opacity":"0.07","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","items":[{"template":"wrapper","type":"column","column":"20","items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"What We\'ve Done","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"22px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"40","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"35px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p><span style=\"font-size:22px;\"><span style=\"color:#3039ac;\">We provide buy-side</span>, sell-side and market infrastructure firms with a full-service offering, including systems integration and technology consulting services, <strong>to assist in delivering</strong> high performance trading and settlement</span></p>\n<p>More than 25 years of experience working in the industry has enabled us to build our services and solutions in strategy, consulting, digital, technology and operations that help our clients with their trading projects around the world. Capabilities we leverage for our clients include</p>\n","text-align":"left","apply-the-content-filter":"disable","font-size":"16px","text-color":"","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"20","items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Our Process","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"22px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"40","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"35px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"text-box","value":{"id":"","class":"","content":"We provide buy-side, sell-side and market infrastructure firms with a full-service offering, including systems integration and technology consulting services, to assist in delivering high performance trading and settlement More than 25 years of experience working in the industry has enabled us to build our services and solutions in strategy, consulting, digital, technology and operations that help our clients with their trading projects around the world. Capabilities we leverage for our clients include","text-align":"left","apply-the-content-filter":"disable","font-size":"16px","text-color":"","padding-bottom":"6px"}},{"template":"element","type":"icon-list","value":{"id":"","class":"","tabs":[{"icon":"fa fa-dot-circle-o","icon-hover":"","title":"Amet Sollicitudin Quam Dolor Mollis","link-url":""},{"icon":"fa fa-dot-circle-o","icon-hover":"","title":"Diipiscing Vestibulum Nullam Venenatis","link-url":""},{"icon":"fa fa-dot-circle-o","icon-hover":"","title":"Diipiscing Vestibulum Nullam Venenatis","link-url":""},{"icon":"fa fa-dot-circle-o","icon-hover":"","title":"Vehicula Vulputate Ligula Mollis","link-url":""}],"columns":"60","enable-divider":"disable","icon-background":"none","icon-color":"#313787","icon-background-color":"","content-color":"","border-color":"","icon-size":"16px","content-size":"16px","list-bottom-margin":"10px","padding-bottom":"10px"}}]},{"template":"wrapper","type":"column","column":"20","items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Feedback From Client","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"22px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"40","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"35px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>We provide buy-side, sell-side and market infrastructure firms with a full-service offering, including systems integration and technology consulting services, to assist in delivering high performance trading and settlement More than 25 years of experience working in the industry has enabled us to build our services and solutions in strategy, consulting, digital, technology and operations that help our clients with their trading projects around the world. Capabilities we leverage for our clients include</p>\n<p>inTech Innovation Lab that keep us at the forefront of innovation. Our Trading helps clients run and transform their front, middle and back-office trading operations. We provide buy-side, sell-side and market infrastructure firms with a full-service offering, including systems integration and technology consulting .</p>\n","text-align":"left","apply-the-content-filter":"disable","font-size":"16px","text-color":"","padding-bottom":"6px"}}]}]}]';
				case 'single-case2': 
					return '[{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"5238","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.2","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"360px","right":"0px","bottom":"160px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"80px","right":"","bottom":"130px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Family Asset Management","caption":"We provide the solution for asset management","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"68px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"14px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"2px","caption-font-uppercase":"enable","left-icon-color":"","title-color":"#ffffff","title-link-hover-color":"","caption-color":"#efefef","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"60px","left":"0px","settings":"unlink"},"margin":{"top":"-90px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","max-width":"840px","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"40px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"5319","thumbnail-size":"full","link-to":"lb-full-image","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"enable","background-shadow-size":{"x":"","y":"","size":"74px","settings":"unlink"},"background-shadow-color":"#0a0a0a","background-shadow-opacity":"0.07","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"60px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Project Title","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h4","icon-font-size":"30px","title-font-size":"27px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Our Trading helps clients run and transform their front, middle and back-office trading operations. We provide buy-side, sell-side and market infrastructure firms with a full-service offering, including systems integration and technology consulting services, to assist in delivering high. Our Trading helps clients run and transform their fro nt, middle and back-office trading operations. We provide buy-side, sell. More than 25 years of experience working in the industry has enabled us to build our services and solutions in strategy, consulting, digital, technology and operations that help our clients with their trading.","text-align":"left","apply-the-content-filter":"disable","font-size":"16px","text-color":"","padding-bottom":"30px"}},{"template":"element","type":"port-info","value":{"id":"","class":"","port-info":[{"key":"Client","value":"DreamAct"},{"key":"Date","value":"17 August 2017"},{"key":"Skills","value":"Project Planning"}],"enable-post-type-tax":"disable","enable-bottom-border":"disable","taxonomy-head-text":"Tags","taxonomy":"portfolio_tag","enable-social-share":"disable","social-facebook":"enable","social-linkedin":"enable","social-google-plus":"enable","social-pinterest":"enable","social-stumbleupon":"enable","social-twitter":"enable","social-email":"disable","padding-bottom":"50px"}}]},{"template":"wrapper","type":"column","column":"24","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"10px","right":"0px","bottom":"0px","left":"20px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"5321","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"enable","background-shadow-size":{"x":"","y":"","size":"74px","settings":"unlink"},"background-shadow-color":"#0a0a0a","background-shadow-opacity":"0.12","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"36","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"50px","right":"0px","bottom":"0px","left":"35px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Help Monitoring","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h4","icon-font-size":"30px","title-font-size":"27px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>More than 25 years of experience working in the industry has enabled us to build our services and solutions in strategy, consulting, digital, technology and operations that help our clients with their trading projects around the world. Capabilities we leverage for our clients include a powerful alliance network with leading capital markets software vendors, and programs such as the FinTech Innovation Lab that keep us at the forefront of innovation. Our Trading helps clients run and transform their front, middle and back-office trading operations. We provide buy-side, sell-side and market infrastructure firms.</p>\n<p><span style=\"font-size: 20px;\">We provide buy-side, sell-side and market infrastructure firms with a full-service offering, including systems integration and technology consulting services, to assist in delivering high performance trading and settlement.</span></p>\n","text-align":"left","apply-the-content-filter":"disable","font-size":"16px","text-color":"","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"20px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"height-1","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"30px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Help Monitoring","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h4","icon-font-size":"30px","title-font-size":"27px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>More than 25 years of experience working in the industry has enabled us to build our services and solutions in strategy, consulting, digital, technology and operations that help our clients with their trading projects around the world. Capabilities we leverage for our clients include a powerful alliance network with leading capital markets software vendors, and programs such as the FinTech Innovation Lab that keep us at the forefront of innovation. Our Trading helps clients run and transform their front, middle and back-office trading operations. We provide buy-side, sell-side and market infrastructure firms.</p>\n<p><span style=\"font-size: 20px;\">We provide buy-side, sell-side and market infrastructure firms with a full-service offering, including systems integration and technology consulting services, to assist in delivering high performance trading and settlement.</span></p>\n","text-align":"left","apply-the-content-filter":"disable","font-size":"16px","text-color":"","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"height-1","centering-sync-height-content":"disable","background-type":"image","background-extending":"right","background-color":"","background-image":"5473","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.2","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"40px","settings":"unlink"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""}}]},{"template":"wrapper","type":"background","items":[{"template":"wrapper","type":"column","column":"20","items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"What We\'ve Done","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"22px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"40","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"35px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p><span style=\"font-size:21px;\"><span style=\"color:#3039ac;\">We provide buy-side</span>, sell-side and market infrastructure firms with a full-service offering, including systems integration and technology consulting services, <strong>to assist in delivering</strong> high performance trading and settlement</span></p>\n<p>More than 25 years of experience working in the industry has enabled us to build our services and solutions in strategy, consulting, digital, technology and operations that help our clients with their trading projects around the world. Capabilities we leverage for our clients include</p>\n","text-align":"left","apply-the-content-filter":"disable","font-size":"16px","text-color":"","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"20","items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Our Process","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"22px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"40","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"35px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"text-box","value":{"id":"","class":"","content":"We provide buy-side, sell-side and market infrastructure firms with a full-service offering, including systems integration and technology consulting services, to assist in delivering high performance trading and settlement More than 25 years of experience working in the industry has enabled us to build our services and solutions in strategy, consulting, digital, technology and operations that help our clients with their trading projects around the world. Capabilities we leverage for our clients include","text-align":"left","apply-the-content-filter":"disable","font-size":"16px","text-color":"","padding-bottom":"6px"}},{"template":"element","type":"icon-list","value":{"id":"","class":"","tabs":[{"icon":"fa fa-dot-circle-o","icon-hover":"","title":"Amet Sollicitudin Quam Dolor Mollis","link-url":""},{"icon":"fa fa-dot-circle-o","icon-hover":"","title":"Diipiscing Vestibulum Nullam Venenatis","link-url":""},{"icon":"fa fa-dot-circle-o","icon-hover":"","title":"Diipiscing Vestibulum Nullam Venenatis","link-url":""},{"icon":"fa fa-dot-circle-o","icon-hover":"","title":"Vehicula Vulputate Ligula Mollis","link-url":""}],"columns":"60","enable-divider":"disable","icon-background":"none","icon-color":"#313787","icon-background-color":"","content-color":"","border-color":"","icon-size":"16px","content-size":"16px","list-bottom-margin":"10px","padding-bottom":"10px"}}]},{"template":"wrapper","type":"column","column":"20","items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Feedback From Client","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"22px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"40","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"35px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>We provide buy-side, sell-side and market infrastructure firms with a full-service offering, including systems integration and technology consulting services, to assist in delivering high performance trading and settlement More than 25 years of experience working in the industry has enabled us to build our services and solutions in strategy, consulting, digital, technology and operations that help our clients with their trading projects around the world. Capabilities we leverage for our clients include</p>\n<p>inTech Innovation Lab that keep us at the forefront of innovation. Our Trading helps clients run and transform their front, middle and back-office trading operations. We provide buy-side, sell-side and market infrastructure firms with a full-service offering, including systems integration and technology consulting .</p>\n","text-align":"left","apply-the-content-filter":"disable","font-size":"16px","text-color":"","padding-bottom":"6px"}}]}]}]';
				case 'single-case3': 
					return '[{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"60px","right":"0px","bottom":"60px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"5317","thumbnail-size":"full","link-to":"lb-full-image","custom-image":"","video-url":"","page-id":"599","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"round","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"70px"}},{"template":"element","type":"image","value":{"id":"","class":"","image":"5467","thumbnail-size":"full","link-to":"lb-full-image","custom-image":"","video-url":"","page-id":"599","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"enable","background-shadow-size":{"x":"","y":"","size":"74px","settings":"unlink"},"background-shadow-color":"#0a0a0a","background-shadow-opacity":"0.07","frame-style":"round","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"10px","right":"0px","bottom":"0px","left":"30px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Project Detail","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h4","icon-font-size":"30px","title-font-size":"27px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"35px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Our Trading helps clients run and transform their front, middle and back-office trading operations. We provide buy-side, sell-side and market infrastructure firms with a full-service offering, including systems integration and technology consulting services, to assist in delivering high. Our Trading helps clients run and transform their front, middle and back-office trading operations. We provide buy-side, sell.","text-align":"left","apply-the-content-filter":"disable","font-size":"16px","text-color":"","padding-bottom":"15px"}},{"template":"element","type":"port-info","value":{"id":"","class":"","port-info":[{"key":"Client","value":"DreamAct"},{"key":"Date","value":"17 August 2017"}],"enable-post-type-tax":"disable","enable-bottom-border":"disable","taxonomy-head-text":"Tags","taxonomy":"portfolio_tag","enable-social-share":"disable","social-facebook":"enable","social-linkedin":"enable","social-google-plus":"enable","social-pinterest":"enable","social-stumbleupon":"enable","social-twitter":"enable","social-email":"disable","padding-bottom":"60px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Result Driven","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h4","icon-font-size":"30px","title-font-size":"25px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"35px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>More than 25 years of experience working in the industry has enabled us to build our services and solutions in strategy, consulting, digital, technology and operations that help our clients with their trading projects around the world. Capabilities we leverage for our clients include a powerful alliance network with leading capital markets software vendors, and programs such as the FinTech Innovation Lab that keep us at the forefront of innovation. Our Trading helps clients run and transform their front, middle and back-office trading operations. We provide buy-side, sell-side and market infrastructure firms with a full-service offering, including systems integration and technology consulting Our Trading helps clients run and transform their front, middle and back-office trading operations.</p>\n<p><span style=\"font-size: 21px;\">We provide buy-side, sell-side and market infrastructure firms with a full-service offering, including systems integration and technology consulting services, to assist in delivering high performance trading and settlement capabilities across.</span></p>\n","text-align":"left","apply-the-content-filter":"disable","font-size":"16px","text-color":"","padding-bottom":"40px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"What We\'ve Done","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h4","icon-font-size":"30px","title-font-size":"25px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"35px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p><span style=\"font-size: 21px;\"><span style=\"color: #3039ac;\">We provide buy-side, sell-side</span> and market infrastructure firms with a full-service offering, including systems integration and technology consulting services,<strong> to assist in delivering</strong> high performance trading and settlement</span></p>\n<p>More than 25 years of experience working in the industry has enabled us to build our services and solutions in strategy, consulting, digital, technology and operations that help our clients with their trading projects around the world. Capabilities we leverage for our clients include</p>\n","text-align":"left","apply-the-content-filter":"disable","font-size":"16px","text-color":"","padding-bottom":"15px"}}]}]}]';
			}

		} // financity_gdlr_core_page_builder_get_page_template
	} // function_exists

	add_filter('gdlr_core_dropdown_tab_content', 'financity_gdlr_core_dropdown_tab_content', 10, 2);
	if( !function_exists('financity_gdlr_core_dropdown_tab_content') ){
		function financity_gdlr_core_dropdown_tab_content($atts, $content){

			global $gdlr_core_tabs;
			$gdlr_core_tabs = array();

			do_shortcode($content);

			$active_tab = 0;

			$ret  = '<span class="gdlr-core-dropdown-tab gdlr-core-js clearfix" >';
			$ret .= '<span class="gdlr-core-dropdown-tab-title" >';
			$ret .= '<span class="gdlr-core-head">' . $gdlr_core_tabs[$active_tab]['title'] . '</span>';
			
			$count = 0;
			$ret .= '<span class="gdlr-core-dropdown-tab-head-wrap" >';
			foreach( $gdlr_core_tabs as $gdlr_core_tab ){
				$ret .= '<span class="gdlr-core-dropdown-tab-head ' . (($count == $active_tab)? 'gdlr-core-active': '') . '" data-index="' . esc_attr($count) . '" >' . $gdlr_core_tab['title'] . '</span>';

				$count ++;
			}
			$ret .= '</span>'; // gdlr-core-dropdown-tab-head-wrap
			$ret .= '</span>'; // gdlr-core-dropdown-tab-title
			$ret .= '<span class="financity-top-bar-divider financity-right-margin" ></span>';

			$count = 0;
			$ret .= '<span class="gdlr-core-dropdown-tab-content-wrap" >';
			foreach( $gdlr_core_tabs as $gdlr_core_tab ){
				$ret .= '<span class="gdlr-core-dropdown-tab-content ' . (($count == $active_tab)? 'gdlr-core-active': '') . '" data-index="' . esc_attr($count) . '" >' . $gdlr_core_tab['content'] . '</span>';

				$count ++;
			}
			$ret .= '</span>';
			$ret .= '</span>'; // gdlr-core-dropdown-tab

			return $ret;

		}
	}